@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.L2IsolationDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The L2IsolationDomain resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### L2IsolationDomains_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l2IsolationDomain = new AzureNative.ManagedNetworkFabric.L2IsolationDomain("l2IsolationDomain", new()
 *     {
 *         L2IsolationDomainName = "example-l2domain",
 *         Location = "eastus",
 *         Mtu = 1500,
 *         NetworkFabricId = "/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName",
 *         ResourceGroupName = "resourceGroupName",
 *         VlanId = 501,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewL2IsolationDomain(ctx, "l2IsolationDomain", &managednetworkfabric.L2IsolationDomainArgs{
 * 			L2IsolationDomainName: pulumi.String("example-l2domain"),
 * 			Location:              pulumi.String("eastus"),
 * 			Mtu:                   pulumi.Int(1500),
 * 			NetworkFabricId:       pulumi.String("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName"),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			VlanId:                pulumi.Int(501),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.L2IsolationDomain;
 * import com.pulumi.azurenative.managednetworkfabric.L2IsolationDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l2IsolationDomain = new L2IsolationDomain("l2IsolationDomain", L2IsolationDomainArgs.builder()
 *             .l2IsolationDomainName("example-l2domain")
 *             .location("eastus")
 *             .mtu(1500)
 *             .networkFabricId("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName")
 *             .resourceGroupName("resourceGroupName")
 *             .vlanId(501)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:L2IsolationDomain wcpalyqmig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/{l2IsolationDomainName}
 * ```
 * @property annotation Switch configuration description.
 * @property l2IsolationDomainName Name of the L2 Isolation Domain
 * @property location The geo-location where the resource lives
 * @property mtu maximum transmission unit. Default value is 1500.
 * @property networkFabricId Network Fabric ARM resource id.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property vlanId vlanId. Example: 501.
 */
public data class L2IsolationDomainArgs(
    public val `annotation`: Output<String>? = null,
    public val l2IsolationDomainName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mtu: Output<Int>? = null,
    public val networkFabricId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.L2IsolationDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.L2IsolationDomainArgs =
        com.pulumi.azurenative.managednetworkfabric.L2IsolationDomainArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .l2IsolationDomainName(l2IsolationDomainName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .networkFabricId(networkFabricId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [L2IsolationDomainArgs].
 */
@PulumiTagMarker
public class L2IsolationDomainArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var l2IsolationDomainName: Output<String>? = null

    private var location: Output<String>? = null

    private var mtu: Output<Int>? = null

    private var networkFabricId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("yrrvqppnmqiynjfk")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the L2 Isolation Domain
     */
    @JvmName("fdsldawraifcrrwy")
    public suspend fun l2IsolationDomainName(`value`: Output<String>) {
        this.l2IsolationDomainName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xmbtowbfwspqwske")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value maximum transmission unit. Default value is 1500.
     */
    @JvmName("xgcdflkebxaisjed")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value Network Fabric ARM resource id.
     */
    @JvmName("ievtfxhqcpatojvr")
    public suspend fun networkFabricId(`value`: Output<String>) {
        this.networkFabricId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fqmiurjclgqcsvhs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vjmwkolartpwvmcn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value vlanId. Example: 501.
     */
    @JvmName("pnixyfoydvqvukkv")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("rornwaxpklfwtyli")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the L2 Isolation Domain
     */
    @JvmName("orpjgniivpqqqfgk")
    public suspend fun l2IsolationDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l2IsolationDomainName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hwyvctgffximdmrb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value maximum transmission unit. Default value is 1500.
     */
    @JvmName("vffduedwsdrioggq")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value Network Fabric ARM resource id.
     */
    @JvmName("vdbcnobnpbtyetmx")
    public suspend fun networkFabricId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("inwfamvtjkepyyfv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kdgvvtgioaukmrfk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vylixfiifmouthtn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value vlanId. Example: 501.
     */
    @JvmName("ffxuwrfjtaasixmt")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): L2IsolationDomainArgs = L2IsolationDomainArgs(
        `annotation` = `annotation`,
        l2IsolationDomainName = l2IsolationDomainName,
        location = location,
        mtu = mtu,
        networkFabricId = networkFabricId,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vlanId = vlanId,
    )
}
