@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AggregateRouteConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AggregateRouteConfigurationResponse.Companion.toKotlin as aggregateRouteConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy.Companion.toKotlin as l3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicyToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [L3IsolationDomain].
 */
@PulumiTagMarker
public class L3IsolationDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: L3IsolationDomainArgs = L3IsolationDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend L3IsolationDomainArgsBuilder.() -> Unit) {
        val builder = L3IsolationDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): L3IsolationDomain {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.L3IsolationDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return L3IsolationDomain(builtJavaResource)
    }
}

/**
 * The L3IsolationDomain resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### L3IsolationDomains_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l3IsolationDomain = new AzureNative.ManagedNetworkFabric.L3IsolationDomain("l3IsolationDomain", new()
 *     {
 *         AggregateRouteConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.AggregateRouteConfigurationArgs
 *         {
 *             Ipv4Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.AggregateRouteArgs
 *                 {
 *                     Prefix = "10.0.0.0/24",
 *                 },
 *             },
 *             Ipv6Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.AggregateRouteArgs
 *                 {
 *                     Prefix = "10.0.0.1",
 *                 },
 *             },
 *         },
 *         ConnectedSubnetRoutePolicy = new AzureNative.ManagedNetworkFabric.Inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs
 *         {
 *             ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
 *         },
 *         Description = "creating L3 isolation domain",
 *         L3IsolationDomainName = "example-l3domain",
 *         Location = "eastus",
 *         NetworkFabricId = "/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName",
 *         RedistributeConnectedSubnets = "True",
 *         RedistributeStaticRoutes = "False",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewL3IsolationDomain(ctx, "l3IsolationDomain", &managednetworkfabric.L3IsolationDomainArgs{
 * 			AggregateRouteConfiguration: managednetworkfabric.AggregateRouteConfigurationResponse{
 * 				Ipv4Routes: managednetworkfabric.AggregateRouteArray{
 * 					&managednetworkfabric.AggregateRouteArgs{
 * 						Prefix: pulumi.String("10.0.0.0/24"),
 * 					},
 * 				},
 * 				Ipv6Routes: managednetworkfabric.AggregateRouteArray{
 * 					&managednetworkfabric.AggregateRouteArgs{
 * 						Prefix: pulumi.String("10.0.0.1"),
 * 					},
 * 				},
 * 			},
 * 			ConnectedSubnetRoutePolicy: &managednetworkfabric.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs{
 * 				ExportRoutePolicyId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"),
 * 			},
 * 			Description:                  pulumi.String("creating L3 isolation domain"),
 * 			L3IsolationDomainName:        pulumi.String("example-l3domain"),
 * 			Location:                     pulumi.String("eastus"),
 * 			NetworkFabricId:              pulumi.String("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName"),
 * 			RedistributeConnectedSubnets: pulumi.String("True"),
 * 			RedistributeStaticRoutes:     pulumi.String("False"),
 * 			ResourceGroupName:            pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.L3IsolationDomain;
 * import com.pulumi.azurenative.managednetworkfabric.L3IsolationDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l3IsolationDomain = new L3IsolationDomain("l3IsolationDomain", L3IsolationDomainArgs.builder()
 *             .aggregateRouteConfiguration(Map.ofEntries(
 *                 Map.entry("ipv4Routes", Map.of("prefix", "10.0.0.0/24")),
 *                 Map.entry("ipv6Routes", Map.of("prefix", "10.0.0.1"))
 *             ))
 *             .connectedSubnetRoutePolicy(Map.of("exportRoutePolicyId", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"))
 *             .description("creating L3 isolation domain")
 *             .l3IsolationDomainName("example-l3domain")
 *             .location("eastus")
 *             .networkFabricId("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName")
 *             .redistributeConnectedSubnets("True")
 *             .redistributeStaticRoutes("False")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:L3IsolationDomain example-l3domain /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/{l3IsolationDomainName}
 * ```
 */
public class L3IsolationDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.L3IsolationDomain,
) : KotlinCustomResource(javaResource, L3IsolationDomainMapper) {
    /**
     * Administrative state of the IsolationDomain. Example: Enabled | Disabled.
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * List of Ipv4 and Ipv6 route configurations.
     */
    public val aggregateRouteConfiguration: Output<AggregateRouteConfigurationResponse>?
        get() = javaResource.aggregateRouteConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> aggregateRouteConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connected Subnet RoutePolicy
     */
    public val connectedSubnetRoutePolicy:
        Output<L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy>?
        get() = javaResource.connectedSubnetRoutePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    l3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicyToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * L3 Isolation Domain description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of resources the L3 Isolation Domain is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val disabledOnResources: Output<List<String>>
        get() = javaResource.disabledOnResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network Fabric ARM resource id.
     */
    public val networkFabricId: Output<String>
        get() = javaResource.networkFabricId().applyValue({ args0 -> args0 })

    /**
     * List of resources the OptionB is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val optionBDisabledOnResources: Output<List<String>>
        get() = javaResource.optionBDisabledOnResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Advertise Connected Subnets. Ex: "True" | "False".
     */
    public val redistributeConnectedSubnets: Output<String>?
        get() = javaResource.redistributeConnectedSubnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Advertise Static Routes. Ex: "True" | "False".
     */
    public val redistributeStaticRoutes: Output<String>?
        get() = javaResource.redistributeStaticRoutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object L3IsolationDomainMapper : ResourceMapper<L3IsolationDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.L3IsolationDomain::class == javaResource::class

    override fun map(javaResource: Resource): L3IsolationDomain = L3IsolationDomain(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.L3IsolationDomain,
    )
}

/**
 * @see [L3IsolationDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [L3IsolationDomain].
 */
public suspend fun l3IsolationDomain(
    name: String,
    block: suspend L3IsolationDomainResourceBuilder.() -> Unit,
): L3IsolationDomain {
    val builder = L3IsolationDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [L3IsolationDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun l3IsolationDomain(name: String): L3IsolationDomain {
    val builder = L3IsolationDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
