@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkInterface].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceArgs = NetworkInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInterface {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkInterface(builtJavaResource)
    }
}

/**
 * Defines the NetworkInterface resource.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkInterfaces_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.ManagedNetworkFabric.NetworkInterface("networkInterface", new()
 *     {
 *         Annotation = "null",
 *         NetworkDeviceName = "networkDeviceName",
 *         NetworkInterfaceName = "networkInterfaceName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkInterface(ctx, "networkInterface", &managednetworkfabric.NetworkInterfaceArgs{
 * 			Annotation:           pulumi.String("null"),
 * 			NetworkDeviceName:    pulumi.String("networkDeviceName"),
 * 			NetworkInterfaceName: pulumi.String("networkInterfaceName"),
 * 			ResourceGroupName:    pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkInterface;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .annotation("null")
 *             .networkDeviceName("networkDeviceName")
 *             .networkInterfaceName("networkInterfaceName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkInterface networkInterfaceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkDevices/{networkDeviceName}/networkInterfaces/{networkInterfaceName}
 * ```
 */
public class NetworkInterface internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkInterface,
) : KotlinCustomResource(javaResource, NetworkInterfaceMapper) {
    /**
     * administrativeState of the network interface. Example: Enabled | Disabled.
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The arm resource id of the interface or compute server its connected to.
     */
    public val connectedTo: Output<String>
        get() = javaResource.connectedTo().applyValue({ args0 -> args0 })

    /**
     * The Interface Type. Example: Management/Data
     */
    public val interfaceType: Output<String>
        get() = javaResource.interfaceType().applyValue({ args0 -> args0 })

    /**
     * ipv4Address.
     */
    public val ipv4Address: Output<String>
        get() = javaResource.ipv4Address().applyValue({ args0 -> args0 })

    /**
     * ipv6Address.
     */
    public val ipv6Address: Output<String>
        get() = javaResource.ipv6Address().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * physicalIdentifier of the network interface.
     */
    public val physicalIdentifier: Output<String>
        get() = javaResource.physicalIdentifier().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkInterfaceMapper : ResourceMapper<NetworkInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkInterface::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterface = NetworkInterface(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NetworkInterface,
    )
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterface].
 */
public suspend fun networkInterface(
    name: String,
    block: suspend NetworkInterfaceResourceBuilder.() -> Unit,
): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterface(name: String): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
