@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkPacketBrokerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NetworkPacketBroker resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NetworkPacketBrokers_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkPacketBroker = new AzureNative.ManagedNetworkFabric.NetworkPacketBroker("networkPacketBroker", new()
 *     {
 *         Location = "eastuseuap",
 *         NetworkFabricId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabrics/example-networkFabric",
 *         NetworkPacketBrokerName = "example-networkPacketBroker",
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key2806", "key" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkPacketBroker(ctx, "networkPacketBroker", &managednetworkfabric.NetworkPacketBrokerArgs{
 * 			Location:                pulumi.String("eastuseuap"),
 * 			NetworkFabricId:         pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabrics/example-networkFabric"),
 * 			NetworkPacketBrokerName: pulumi.String("example-networkPacketBroker"),
 * 			ResourceGroupName:       pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key2806": pulumi.String("key"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkPacketBroker;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkPacketBrokerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkPacketBroker = new NetworkPacketBroker("networkPacketBroker", NetworkPacketBrokerArgs.builder()
 *             .location("eastuseuap")
 *             .networkFabricId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabrics/example-networkFabric")
 *             .networkPacketBrokerName("example-networkPacketBroker")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key2806", "key"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkPacketBroker example-networkPacketBroker /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/{networkPacketBrokerName}
 * ```
 * @property location The geo-location where the resource lives
 * @property networkFabricId ARM resource ID of the Network Fabric.
 * @property networkPacketBrokerName Name of the Network Packet Broker.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkPacketBrokerArgs(
    public val location: Output<String>? = null,
    public val networkFabricId: Output<String>? = null,
    public val networkPacketBrokerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkPacketBrokerArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkPacketBrokerArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkPacketBrokerArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFabricId(networkFabricId?.applyValue({ args0 -> args0 }))
            .networkPacketBrokerName(networkPacketBrokerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkPacketBrokerArgs].
 */
@PulumiTagMarker
public class NetworkPacketBrokerArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var networkFabricId: Output<String>? = null

    private var networkPacketBrokerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("efomitqxtmagbfki")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ARM resource ID of the Network Fabric.
     */
    @JvmName("yppuqfbdgxjusdiu")
    public suspend fun networkFabricId(`value`: Output<String>) {
        this.networkFabricId = value
    }

    /**
     * @param value Name of the Network Packet Broker.
     */
    @JvmName("kwllpvwsdeuvprcv")
    public suspend fun networkPacketBrokerName(`value`: Output<String>) {
        this.networkPacketBrokerName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("agvreqcmscdxrmte")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lujnjjdcmhrubxij")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gtyxsoumkwmylumg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ARM resource ID of the Network Fabric.
     */
    @JvmName("bfvufxjubhagmltp")
    public suspend fun networkFabricId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricId = mapped
    }

    /**
     * @param value Name of the Network Packet Broker.
     */
    @JvmName("oaquwrhsmijlvhla")
    public suspend fun networkPacketBrokerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkPacketBrokerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("raggrjoihmnstulw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ujmvdodrdnaglfum")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iosbyrmpekekmlof")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkPacketBrokerArgs = NetworkPacketBrokerArgs(
        location = location,
        networkFabricId = networkFabricId,
        networkPacketBrokerName = networkPacketBrokerName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
