@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.AccessControlListConditionPropertiesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.ConditionActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Access Control List condition model.
 * @property action action. Example: allow | deny.
 * @property annotation Switch configuration description.
 * @property destinationAddress destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
 * @property destinationPort destinationPort. Example: any | 1253
 * @property protocol TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
 * @property sequenceNumber sequenceNumber of the Access Control List.
 * @property sourceAddress sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
 * @property sourcePort sourcePort. Example: any | 1253
 */
public data class AccessControlListConditionPropertiesArgs(
    public val action: Output<Either<String, ConditionActionType>>,
    public val `annotation`: Output<String>? = null,
    public val destinationAddress: Output<String>,
    public val destinationPort: Output<String>,
    public val protocol: Output<Int>,
    public val sequenceNumber: Output<Int>,
    public val sourceAddress: Output<String>,
    public val sourcePort: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.AccessControlListConditionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.AccessControlListConditionPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.AccessControlListConditionPropertiesArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .destinationAddress(destinationAddress.applyValue({ args0 -> args0 }))
            .destinationPort(destinationPort.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .sequenceNumber(sequenceNumber.applyValue({ args0 -> args0 }))
            .sourceAddress(sourceAddress.applyValue({ args0 -> args0 }))
            .sourcePort(sourcePort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessControlListConditionPropertiesArgs].
 */
@PulumiTagMarker
public class AccessControlListConditionPropertiesArgsBuilder internal constructor() {
    private var action: Output<Either<String, ConditionActionType>>? = null

    private var `annotation`: Output<String>? = null

    private var destinationAddress: Output<String>? = null

    private var destinationPort: Output<String>? = null

    private var protocol: Output<Int>? = null

    private var sequenceNumber: Output<Int>? = null

    private var sourceAddress: Output<String>? = null

    private var sourcePort: Output<String>? = null

    /**
     * @param value action. Example: allow | deny.
     */
    @JvmName("rxyrpwnnmjtqetrs")
    public suspend fun action(`value`: Output<Either<String, ConditionActionType>>) {
        this.action = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("jjajihxwqnxjxlmi")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
     */
    @JvmName("ccjplpkvrwojjlls")
    public suspend fun destinationAddress(`value`: Output<String>) {
        this.destinationAddress = value
    }

    /**
     * @param value destinationPort. Example: any | 1253
     */
    @JvmName("uiqkpnbisumjbjxi")
    public suspend fun destinationPort(`value`: Output<String>) {
        this.destinationPort = value
    }

    /**
     * @param value TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
     */
    @JvmName("eveehunmhhsnyikq")
    public suspend fun protocol(`value`: Output<Int>) {
        this.protocol = value
    }

    /**
     * @param value sequenceNumber of the Access Control List.
     */
    @JvmName("ttnrtqokxvbbhqep")
    public suspend fun sequenceNumber(`value`: Output<Int>) {
        this.sequenceNumber = value
    }

    /**
     * @param value sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
     */
    @JvmName("bftymtnfoaddyseb")
    public suspend fun sourceAddress(`value`: Output<String>) {
        this.sourceAddress = value
    }

    /**
     * @param value sourcePort. Example: any | 1253
     */
    @JvmName("cyktnthibikgcnpy")
    public suspend fun sourcePort(`value`: Output<String>) {
        this.sourcePort = value
    }

    /**
     * @param value action. Example: allow | deny.
     */
    @JvmName("skicntpmscdkilvi")
    public suspend fun action(`value`: Either<String, ConditionActionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value action. Example: allow | deny.
     */
    @JvmName("vocnqwtaklekakab")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConditionActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value action. Example: allow | deny.
     */
    @JvmName("qqsekvlgpckrvvam")
    public fun action(`value`: ConditionActionType) {
        val toBeMapped = Either.ofRight<String, ConditionActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("gipbklyhnwywhrge")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
     */
    @JvmName("fpcnwjkkudyrueor")
    public suspend fun destinationAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddress = mapped
    }

    /**
     * @param value destinationPort. Example: any | 1253
     */
    @JvmName("scnnnkunynckfbjv")
    public suspend fun destinationPort(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
     */
    @JvmName("dvwuqtltvwimbxno")
    public suspend fun protocol(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value sequenceNumber of the Access Control List.
     */
    @JvmName("alfyeskksnpwqadm")
    public suspend fun sequenceNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sequenceNumber = mapped
    }

    /**
     * @param value sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
     */
    @JvmName("pxvqajvfcvdmjvkw")
    public suspend fun sourceAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddress = mapped
    }

    /**
     * @param value sourcePort. Example: any | 1253
     */
    @JvmName("hpoqbcikdsyxatal")
    public suspend fun sourcePort(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePort = mapped
    }

    internal fun build(): AccessControlListConditionPropertiesArgs =
        AccessControlListConditionPropertiesArgs(
            action = action ?: throw PulumiNullFieldException("action"),
            `annotation` = `annotation`,
            destinationAddress = destinationAddress ?: throw PulumiNullFieldException("destinationAddress"),
            destinationPort = destinationPort ?: throw PulumiNullFieldException("destinationPort"),
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            sequenceNumber = sequenceNumber ?: throw PulumiNullFieldException("sequenceNumber"),
            sourceAddress = sourceAddress ?: throw PulumiNullFieldException("sourceAddress"),
            sourcePort = sourcePort ?: throw PulumiNullFieldException("sourcePort"),
        )
}
