@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dynamic match configuration object.
 * @property ipGroups List of IP Groups.
 * @property portGroups List of the port groups.
 * @property vlanGroups List of vlan groups.
 */
public data class CommonDynamicMatchConfigurationArgs(
    public val ipGroups: Output<List<IpGroupPropertiesArgs>>? = null,
    public val portGroups: Output<List<PortGroupPropertiesArgs>>? = null,
    public val vlanGroups: Output<List<VlanGroupPropertiesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs.builder()
            .ipGroups(
                ipGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .portGroups(
                portGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vlanGroups(
                vlanGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CommonDynamicMatchConfigurationArgs].
 */
@PulumiTagMarker
public class CommonDynamicMatchConfigurationArgsBuilder internal constructor() {
    private var ipGroups: Output<List<IpGroupPropertiesArgs>>? = null

    private var portGroups: Output<List<PortGroupPropertiesArgs>>? = null

    private var vlanGroups: Output<List<VlanGroupPropertiesArgs>>? = null

    /**
     * @param value List of IP Groups.
     */
    @JvmName("agjbpynflkrlchvm")
    public suspend fun ipGroups(`value`: Output<List<IpGroupPropertiesArgs>>) {
        this.ipGroups = value
    }

    @JvmName("pwaksgjwnddpkyjx")
    public suspend fun ipGroups(vararg values: Output<IpGroupPropertiesArgs>) {
        this.ipGroups = Output.all(values.asList())
    }

    /**
     * @param values List of IP Groups.
     */
    @JvmName("pyxdbrxtsvubaljb")
    public suspend fun ipGroups(values: List<Output<IpGroupPropertiesArgs>>) {
        this.ipGroups = Output.all(values)
    }

    /**
     * @param value List of the port groups.
     */
    @JvmName("ngmovdlkdulfxjos")
    public suspend fun portGroups(`value`: Output<List<PortGroupPropertiesArgs>>) {
        this.portGroups = value
    }

    @JvmName("tuwkdvevxmwyrocf")
    public suspend fun portGroups(vararg values: Output<PortGroupPropertiesArgs>) {
        this.portGroups = Output.all(values.asList())
    }

    /**
     * @param values List of the port groups.
     */
    @JvmName("idcqaiwxgefslesn")
    public suspend fun portGroups(values: List<Output<PortGroupPropertiesArgs>>) {
        this.portGroups = Output.all(values)
    }

    /**
     * @param value List of vlan groups.
     */
    @JvmName("chanujlwduoatnlf")
    public suspend fun vlanGroups(`value`: Output<List<VlanGroupPropertiesArgs>>) {
        this.vlanGroups = value
    }

    @JvmName("odqwslqxdxccpyow")
    public suspend fun vlanGroups(vararg values: Output<VlanGroupPropertiesArgs>) {
        this.vlanGroups = Output.all(values.asList())
    }

    /**
     * @param values List of vlan groups.
     */
    @JvmName("ocqjkkmkqocbgflb")
    public suspend fun vlanGroups(values: List<Output<VlanGroupPropertiesArgs>>) {
        this.vlanGroups = Output.all(values)
    }

    /**
     * @param value List of IP Groups.
     */
    @JvmName("aobfjxlgloyilyfj")
    public suspend fun ipGroups(`value`: List<IpGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroups = mapped
    }

    /**
     * @param argument List of IP Groups.
     */
    @JvmName("wphrmkrojirlcync")
    public suspend fun ipGroups(argument: List<suspend IpGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipGroups = mapped
    }

    /**
     * @param argument List of IP Groups.
     */
    @JvmName("vbprrvweifgsiyyf")
    public suspend fun ipGroups(vararg argument: suspend IpGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipGroups = mapped
    }

    /**
     * @param argument List of IP Groups.
     */
    @JvmName("bepqlewydomboysj")
    public suspend fun ipGroups(argument: suspend IpGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpGroupPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipGroups = mapped
    }

    /**
     * @param values List of IP Groups.
     */
    @JvmName("gjasfvtbawutmoob")
    public suspend fun ipGroups(vararg values: IpGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipGroups = mapped
    }

    /**
     * @param value List of the port groups.
     */
    @JvmName("xwivqldxhumyuuum")
    public suspend fun portGroups(`value`: List<PortGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portGroups = mapped
    }

    /**
     * @param argument List of the port groups.
     */
    @JvmName("ugaolwjviausixxg")
    public suspend fun portGroups(argument: List<suspend PortGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PortGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portGroups = mapped
    }

    /**
     * @param argument List of the port groups.
     */
    @JvmName("gnbqwfpupfkauiht")
    public suspend fun portGroups(
        vararg
        argument: suspend PortGroupPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PortGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portGroups = mapped
    }

    /**
     * @param argument List of the port groups.
     */
    @JvmName("rrulfvbmypqudrik")
    public suspend fun portGroups(argument: suspend PortGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PortGroupPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.portGroups = mapped
    }

    /**
     * @param values List of the port groups.
     */
    @JvmName("ypptaejqansliuig")
    public suspend fun portGroups(vararg values: PortGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portGroups = mapped
    }

    /**
     * @param value List of vlan groups.
     */
    @JvmName("uylwchafyjlcrbah")
    public suspend fun vlanGroups(`value`: List<VlanGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanGroups = mapped
    }

    /**
     * @param argument List of vlan groups.
     */
    @JvmName("hbpnxyimrjssplkb")
    public suspend fun vlanGroups(argument: List<suspend VlanGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VlanGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vlanGroups = mapped
    }

    /**
     * @param argument List of vlan groups.
     */
    @JvmName("xuuvbwulldlliulp")
    public suspend fun vlanGroups(
        vararg
        argument: suspend VlanGroupPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VlanGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vlanGroups = mapped
    }

    /**
     * @param argument List of vlan groups.
     */
    @JvmName("jnikibadbagebrkq")
    public suspend fun vlanGroups(argument: suspend VlanGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VlanGroupPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vlanGroups = mapped
    }

    /**
     * @param values List of vlan groups.
     */
    @JvmName("ibkuooemwfgfprja")
    public suspend fun vlanGroups(vararg values: VlanGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vlanGroups = mapped
    }

    internal fun build(): CommonDynamicMatchConfigurationArgs = CommonDynamicMatchConfigurationArgs(
        ipGroups = ipGroups,
        portGroups = portGroups,
        vlanGroups = vlanGroups,
    )
}
