@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetExternalNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalNetworkName Name of the ExternalNetwork
 * @property l3IsolationDomainName Name of the L3IsolationDomain
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetExternalNetworkPlainArgs(
    public val externalNetworkName: String,
    public val l3IsolationDomainName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetExternalNetworkPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetExternalNetworkPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetExternalNetworkPlainArgs.builder()
            .externalNetworkName(externalNetworkName.let({ args0 -> args0 }))
            .l3IsolationDomainName(l3IsolationDomainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExternalNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetExternalNetworkPlainArgsBuilder internal constructor() {
    private var externalNetworkName: String? = null

    private var l3IsolationDomainName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the ExternalNetwork
     */
    @JvmName("rrhjwduedxbxewyk")
    public suspend fun externalNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.externalNetworkName = mapped
    }

    /**
     * @param value Name of the L3IsolationDomain
     */
    @JvmName("aschwdgumtrexqeo")
    public suspend fun l3IsolationDomainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l3IsolationDomainName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tkanxvtkfscnbbvt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExternalNetworkPlainArgs = GetExternalNetworkPlainArgs(
        externalNetworkName = externalNetworkName ?: throw PulumiNullFieldException("externalNetworkName"),
        l3IsolationDomainName = l3IsolationDomainName ?: throw
            PulumiNullFieldException("l3IsolationDomainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
