@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetL2IsolationDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property l2IsolationDomainName Name of the L2 Isolation Domain
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetL2IsolationDomainPlainArgs(
    public val l2IsolationDomainName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetL2IsolationDomainPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetL2IsolationDomainPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetL2IsolationDomainPlainArgs.builder()
            .l2IsolationDomainName(l2IsolationDomainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetL2IsolationDomainPlainArgs].
 */
@PulumiTagMarker
public class GetL2IsolationDomainPlainArgsBuilder internal constructor() {
    private var l2IsolationDomainName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the L2 Isolation Domain
     */
    @JvmName("pqcwaaborkhvktfw")
    public suspend fun l2IsolationDomainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l2IsolationDomainName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("heewpehgjkokjdip")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetL2IsolationDomainPlainArgs = GetL2IsolationDomainPlainArgs(
        l2IsolationDomainName = l2IsolationDomainName ?: throw
            PulumiNullFieldException("l2IsolationDomainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
