@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkDeviceName Name of the NetworkDevice
 * @property networkInterfaceName Name of the NetworkInterfaceName
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkInterfacePlainArgs(
    public val networkDeviceName: String,
    public val networkInterfaceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkInterfacePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkInterfacePlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkInterfacePlainArgs.builder()
            .networkDeviceName(networkDeviceName.let({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfacePlainArgsBuilder internal constructor() {
    private var networkDeviceName: String? = null

    private var networkInterfaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the NetworkDevice
     */
    @JvmName("wfhlnkmxpbfumxri")
    public suspend fun networkDeviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkDeviceName = mapped
    }

    /**
     * @param value Name of the NetworkInterfaceName
     */
    @JvmName("ibyasntyexugjyyp")
    public suspend fun networkInterfaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("revfdylgsehumfvw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkInterfacePlainArgs = GetNetworkInterfacePlainArgs(
        networkDeviceName = networkDeviceName ?: throw PulumiNullFieldException("networkDeviceName"),
        networkInterfaceName = networkInterfaceName ?: throw
            PulumiNullFieldException("networkInterfaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
