@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkToNetworkInterconnectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkFabricName Name of the NetworkFabric.
 * @property networkToNetworkInterconnectName Name of the NetworkToNetworkInterconnect
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkToNetworkInterconnectPlainArgs(
    public val networkFabricName: String,
    public val networkToNetworkInterconnectName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkToNetworkInterconnectPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkToNetworkInterconnectPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkToNetworkInterconnectPlainArgs.builder()
            .networkFabricName(networkFabricName.let({ args0 -> args0 }))
            .networkToNetworkInterconnectName(networkToNetworkInterconnectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkToNetworkInterconnectPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkToNetworkInterconnectPlainArgsBuilder internal constructor() {
    private var networkFabricName: String? = null

    private var networkToNetworkInterconnectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the NetworkFabric.
     */
    @JvmName("weeidhfrejdqljwu")
    public suspend fun networkFabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFabricName = mapped
    }

    /**
     * @param value Name of the NetworkToNetworkInterconnect
     */
    @JvmName("vfbcaunhxqcbscml")
    public suspend fun networkToNetworkInterconnectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkToNetworkInterconnectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hhoronleqtvxnajx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkToNetworkInterconnectPlainArgs =
        GetNetworkToNetworkInterconnectPlainArgs(
            networkFabricName = networkFabricName ?: throw PulumiNullFieldException("networkFabricName"),
            networkToNetworkInterconnectName = networkToNetworkInterconnectName ?: throw
                PulumiNullFieldException("networkToNetworkInterconnectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
