@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.IpCommunityIdListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IP Community ID list properties.
 * @property ipCommunityIds List of IP Community resource IDs.
 */
public data class IpCommunityIdListArgs(
    public val ipCommunityIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.IpCommunityIdListArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.IpCommunityIdListArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.IpCommunityIdListArgs.builder()
            .ipCommunityIds(ipCommunityIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IpCommunityIdListArgs].
 */
@PulumiTagMarker
public class IpCommunityIdListArgsBuilder internal constructor() {
    private var ipCommunityIds: Output<List<String>>? = null

    /**
     * @param value List of IP Community resource IDs.
     */
    @JvmName("qutdsbkpvilreguc")
    public suspend fun ipCommunityIds(`value`: Output<List<String>>) {
        this.ipCommunityIds = value
    }

    @JvmName("cnpqoeaxmqlnvnwh")
    public suspend fun ipCommunityIds(vararg values: Output<String>) {
        this.ipCommunityIds = Output.all(values.asList())
    }

    /**
     * @param values List of IP Community resource IDs.
     */
    @JvmName("ohsojxeegrwhqvtb")
    public suspend fun ipCommunityIds(values: List<Output<String>>) {
        this.ipCommunityIds = Output.all(values)
    }

    /**
     * @param value List of IP Community resource IDs.
     */
    @JvmName("tnboblbruftaimbs")
    public suspend fun ipCommunityIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipCommunityIds = mapped
    }

    /**
     * @param values List of IP Community resource IDs.
     */
    @JvmName("pyabjknflblbfryl")
    public suspend fun ipCommunityIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipCommunityIds = mapped
    }

    internal fun build(): IpCommunityIdListArgs = IpCommunityIdListArgs(
        ipCommunityIds = ipCommunityIds,
    )
}
