@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.IpMatchConditionArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.PrefixType
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.SourceDestinationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the condition that can be filtered using the selected IPs.
 * @property ipGroupNames The List of IP Group Names that need to be matched.
 * @property ipPrefixValues The list of IP Prefixes that need to be matched.
 * @property prefixType IP Prefix Type that needs to be matched.
 * @property type IP Address type that needs to be matched.
 */
public data class IpMatchConditionArgs(
    public val ipGroupNames: Output<List<String>>? = null,
    public val ipPrefixValues: Output<List<String>>? = null,
    public val prefixType: Output<Either<String, PrefixType>>? = null,
    public val type: Output<Either<String, SourceDestinationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.IpMatchConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.IpMatchConditionArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.IpMatchConditionArgs.builder()
            .ipGroupNames(ipGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipPrefixValues(ipPrefixValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixType(
                prefixType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IpMatchConditionArgs].
 */
@PulumiTagMarker
public class IpMatchConditionArgsBuilder internal constructor() {
    private var ipGroupNames: Output<List<String>>? = null

    private var ipPrefixValues: Output<List<String>>? = null

    private var prefixType: Output<Either<String, PrefixType>>? = null

    private var type: Output<Either<String, SourceDestinationType>>? = null

    /**
     * @param value The List of IP Group Names that need to be matched.
     */
    @JvmName("uvqghmuqfukmlydf")
    public suspend fun ipGroupNames(`value`: Output<List<String>>) {
        this.ipGroupNames = value
    }

    @JvmName("ujtvvrviakrlxrxp")
    public suspend fun ipGroupNames(vararg values: Output<String>) {
        this.ipGroupNames = Output.all(values.asList())
    }

    /**
     * @param values The List of IP Group Names that need to be matched.
     */
    @JvmName("nobfnmbqsipsemtq")
    public suspend fun ipGroupNames(values: List<Output<String>>) {
        this.ipGroupNames = Output.all(values)
    }

    /**
     * @param value The list of IP Prefixes that need to be matched.
     */
    @JvmName("iayfmupembsyslmn")
    public suspend fun ipPrefixValues(`value`: Output<List<String>>) {
        this.ipPrefixValues = value
    }

    @JvmName("mtwawybbysvrngqr")
    public suspend fun ipPrefixValues(vararg values: Output<String>) {
        this.ipPrefixValues = Output.all(values.asList())
    }

    /**
     * @param values The list of IP Prefixes that need to be matched.
     */
    @JvmName("lwwnamfnatvapufy")
    public suspend fun ipPrefixValues(values: List<Output<String>>) {
        this.ipPrefixValues = Output.all(values)
    }

    /**
     * @param value IP Prefix Type that needs to be matched.
     */
    @JvmName("yofqlipcoeapkyrj")
    public suspend fun prefixType(`value`: Output<Either<String, PrefixType>>) {
        this.prefixType = value
    }

    /**
     * @param value IP Address type that needs to be matched.
     */
    @JvmName("sgwavjvcrwrhcchj")
    public suspend fun type(`value`: Output<Either<String, SourceDestinationType>>) {
        this.type = value
    }

    /**
     * @param value The List of IP Group Names that need to be matched.
     */
    @JvmName("raogyijmohmlwcow")
    public suspend fun ipGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroupNames = mapped
    }

    /**
     * @param values The List of IP Group Names that need to be matched.
     */
    @JvmName("pwlhmafdhxrqhmle")
    public suspend fun ipGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipGroupNames = mapped
    }

    /**
     * @param value The list of IP Prefixes that need to be matched.
     */
    @JvmName("tesyhneqbtioclfq")
    public suspend fun ipPrefixValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixValues = mapped
    }

    /**
     * @param values The list of IP Prefixes that need to be matched.
     */
    @JvmName("jdrybjmrkvjassnj")
    public suspend fun ipPrefixValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPrefixValues = mapped
    }

    /**
     * @param value IP Prefix Type that needs to be matched.
     */
    @JvmName("udbyevgkbolguqqn")
    public suspend fun prefixType(`value`: Either<String, PrefixType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value IP Prefix Type that needs to be matched.
     */
    @JvmName("aefdkbuqqnsihxte")
    public fun prefixType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrefixType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value IP Prefix Type that needs to be matched.
     */
    @JvmName("qqlgahbfsylwrhsm")
    public fun prefixType(`value`: PrefixType) {
        val toBeMapped = Either.ofRight<String, PrefixType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value IP Address type that needs to be matched.
     */
    @JvmName("tnoyeofrlavcicmn")
    public suspend fun type(`value`: Either<String, SourceDestinationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value IP Address type that needs to be matched.
     */
    @JvmName("haebttxruavhnrkk")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceDestinationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value IP Address type that needs to be matched.
     */
    @JvmName("krtciuttmfmlxpor")
    public fun type(`value`: SourceDestinationType) {
        val toBeMapped = Either.ofRight<String, SourceDestinationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IpMatchConditionArgs = IpMatchConditionArgs(
        ipGroupNames = ipGroupNames,
        ipPrefixValues = ipPrefixValues,
        prefixType = prefixType,
        type = type,
    )
}
