@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.NeighborGroupDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An array of destination IPv4 Addresses or IPv6 Addresses.
 * @property ipv4Addresses Array of IPv4 Addresses.
 * @property ipv6Addresses Array of IPv6 Addresses.
 */
public data class NeighborGroupDestinationArgs(
    public val ipv4Addresses: Output<List<String>>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.NeighborGroupDestinationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.NeighborGroupDestinationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.NeighborGroupDestinationArgs.builder()
            .ipv4Addresses(ipv4Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NeighborGroupDestinationArgs].
 */
@PulumiTagMarker
public class NeighborGroupDestinationArgsBuilder internal constructor() {
    private var ipv4Addresses: Output<List<String>>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    /**
     * @param value Array of IPv4 Addresses.
     */
    @JvmName("oqporjnhwxuucawf")
    public suspend fun ipv4Addresses(`value`: Output<List<String>>) {
        this.ipv4Addresses = value
    }

    @JvmName("bgrlgjqmyttissqj")
    public suspend fun ipv4Addresses(vararg values: Output<String>) {
        this.ipv4Addresses = Output.all(values.asList())
    }

    /**
     * @param values Array of IPv4 Addresses.
     */
    @JvmName("vtynhmtmebkknorc")
    public suspend fun ipv4Addresses(values: List<Output<String>>) {
        this.ipv4Addresses = Output.all(values)
    }

    /**
     * @param value Array of IPv6 Addresses.
     */
    @JvmName("cgakeqwsdjhegwvx")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("fpbndynvmawuxbav")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values Array of IPv6 Addresses.
     */
    @JvmName("sqtttmpviletfmsl")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Array of IPv4 Addresses.
     */
    @JvmName("vbinhstorlpfkery")
    public suspend fun ipv4Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Addresses = mapped
    }

    /**
     * @param values Array of IPv4 Addresses.
     */
    @JvmName("flhutgjfhuuvmkvp")
    public suspend fun ipv4Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Addresses = mapped
    }

    /**
     * @param value Array of IPv6 Addresses.
     */
    @JvmName("vcffijxtmsqjhpli")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values Array of IPv6 Addresses.
     */
    @JvmName("itctoalyrgqnfgvj")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    internal fun build(): NeighborGroupDestinationArgs = NeighborGroupDestinationArgs(
        ipv4Addresses = ipv4Addresses,
        ipv6Addresses = ipv6Addresses,
    )
}
