@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapPropertiesDestinationsArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.DestinationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Destination.
 * @property destinationId The destination Id. ARM Resource ID of either NNI or Internal Networks.
 * @property destinationTapRuleId ARM Resource ID of destination Tap Rule that contains match configurations.
 * @property destinationType Type of destination. Input can be IsolationDomain or Direct.
 * @property isolationDomainProperties Isolation Domain Properties.
 * @property name Destination name.
 */
public data class NetworkTapPropertiesDestinationsArgs(
    public val destinationId: Output<String>,
    public val destinationTapRuleId: Output<String>? = null,
    public val destinationType: Output<Either<String, DestinationType>>,
    public val isolationDomainProperties: Output<IsolationDomainPropertiesArgs>? = null,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapPropertiesDestinationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapPropertiesDestinationsArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapPropertiesDestinationsArgs.builder()
            .destinationId(destinationId.applyValue({ args0 -> args0 }))
            .destinationTapRuleId(destinationTapRuleId?.applyValue({ args0 -> args0 }))
            .destinationType(
                destinationType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .isolationDomainProperties(
                isolationDomainProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkTapPropertiesDestinationsArgs].
 */
@PulumiTagMarker
public class NetworkTapPropertiesDestinationsArgsBuilder internal constructor() {
    private var destinationId: Output<String>? = null

    private var destinationTapRuleId: Output<String>? = null

    private var destinationType: Output<Either<String, DestinationType>>? = null

    private var isolationDomainProperties: Output<IsolationDomainPropertiesArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The destination Id. ARM Resource ID of either NNI or Internal Networks.
     */
    @JvmName("ckaunucoagijwaea")
    public suspend fun destinationId(`value`: Output<String>) {
        this.destinationId = value
    }

    /**
     * @param value ARM Resource ID of destination Tap Rule that contains match configurations.
     */
    @JvmName("fwopyydbamatxcii")
    public suspend fun destinationTapRuleId(`value`: Output<String>) {
        this.destinationTapRuleId = value
    }

    /**
     * @param value Type of destination. Input can be IsolationDomain or Direct.
     */
    @JvmName("qtvppayetxaajyuu")
    public suspend fun destinationType(`value`: Output<Either<String, DestinationType>>) {
        this.destinationType = value
    }

    /**
     * @param value Isolation Domain Properties.
     */
    @JvmName("uovsvijkccnpiowd")
    public suspend fun isolationDomainProperties(`value`: Output<IsolationDomainPropertiesArgs>) {
        this.isolationDomainProperties = value
    }

    /**
     * @param value Destination name.
     */
    @JvmName("mseqmadyytcpvsuf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The destination Id. ARM Resource ID of either NNI or Internal Networks.
     */
    @JvmName("gwveblwriyvfvtja")
    public suspend fun destinationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationId = mapped
    }

    /**
     * @param value ARM Resource ID of destination Tap Rule that contains match configurations.
     */
    @JvmName("tulgkdfjsinckdub")
    public suspend fun destinationTapRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationTapRuleId = mapped
    }

    /**
     * @param value Type of destination. Input can be IsolationDomain or Direct.
     */
    @JvmName("yjlqxmoepigofgps")
    public suspend fun destinationType(`value`: Either<String, DestinationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value Type of destination. Input can be IsolationDomain or Direct.
     */
    @JvmName("xaommrosaimrcvon")
    public fun destinationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DestinationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value Type of destination. Input can be IsolationDomain or Direct.
     */
    @JvmName("lusfodfhugqmlieh")
    public fun destinationType(`value`: DestinationType) {
        val toBeMapped = Either.ofRight<String, DestinationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value Isolation Domain Properties.
     */
    @JvmName("hahbsjvqbhbkypgu")
    public suspend fun isolationDomainProperties(`value`: IsolationDomainPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isolationDomainProperties = mapped
    }

    /**
     * @param argument Isolation Domain Properties.
     */
    @JvmName("vjpbulsidngxvlmu")
    public suspend
    fun isolationDomainProperties(argument: suspend IsolationDomainPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IsolationDomainPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.isolationDomainProperties = mapped
    }

    /**
     * @param value Destination name.
     */
    @JvmName("mscuqcmyixjbgqby")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): NetworkTapPropertiesDestinationsArgs = NetworkTapPropertiesDestinationsArgs(
        destinationId = destinationId ?: throw PulumiNullFieldException("destinationId"),
        destinationTapRuleId = destinationTapRuleId,
        destinationType = destinationType ?: throw PulumiNullFieldException("destinationType"),
        isolationDomainProperties = isolationDomainProperties,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
