@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleActionArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.BooleanEnumProperty
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.TapRuleActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Action that need to performed.
 * @property destinationId Destination Id. The ARM resource Id may be either Network To Network Interconnect or NeighborGroup.
 * @property isTimestampEnabled The parameter to enable or disable the timestamp.
 * @property matchConfigurationName The name of the match configuration. This is used when Goto type is provided. If Goto type is selected and no match configuration name is provided. It goes to next configuration.
 * @property truncate Truncate. 0 indicates do not truncate.
 * @property type Type of actions that can be performed.
 */
public data class NetworkTapRuleActionArgs(
    public val destinationId: Output<String>? = null,
    public val isTimestampEnabled: Output<Either<String, BooleanEnumProperty>>? = null,
    public val matchConfigurationName: Output<String>? = null,
    public val truncate: Output<String>? = null,
    public val type: Output<Either<String, TapRuleActionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleActionArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleActionArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleActionArgs.builder()
            .destinationId(destinationId?.applyValue({ args0 -> args0 }))
            .isTimestampEnabled(
                isTimestampEnabled?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .matchConfigurationName(matchConfigurationName?.applyValue({ args0 -> args0 }))
            .truncate(truncate?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkTapRuleActionArgs].
 */
@PulumiTagMarker
public class NetworkTapRuleActionArgsBuilder internal constructor() {
    private var destinationId: Output<String>? = null

    private var isTimestampEnabled: Output<Either<String, BooleanEnumProperty>>? = null

    private var matchConfigurationName: Output<String>? = null

    private var truncate: Output<String>? = null

    private var type: Output<Either<String, TapRuleActionType>>? = null

    /**
     * @param value Destination Id. The ARM resource Id may be either Network To Network Interconnect or NeighborGroup.
     */
    @JvmName("jxeagwnhjtscpchw")
    public suspend fun destinationId(`value`: Output<String>) {
        this.destinationId = value
    }

    /**
     * @param value The parameter to enable or disable the timestamp.
     */
    @JvmName("wdweharprkgguivf")
    public suspend fun isTimestampEnabled(`value`: Output<Either<String, BooleanEnumProperty>>) {
        this.isTimestampEnabled = value
    }

    /**
     * @param value The name of the match configuration. This is used when Goto type is provided. If Goto type is selected and no match configuration name is provided. It goes to next configuration.
     */
    @JvmName("ehoyljpchxjhxrwl")
    public suspend fun matchConfigurationName(`value`: Output<String>) {
        this.matchConfigurationName = value
    }

    /**
     * @param value Truncate. 0 indicates do not truncate.
     */
    @JvmName("tadiujphdxudwggw")
    public suspend fun truncate(`value`: Output<String>) {
        this.truncate = value
    }

    /**
     * @param value Type of actions that can be performed.
     */
    @JvmName("jecpgbfyydygmxrb")
    public suspend fun type(`value`: Output<Either<String, TapRuleActionType>>) {
        this.type = value
    }

    /**
     * @param value Destination Id. The ARM resource Id may be either Network To Network Interconnect or NeighborGroup.
     */
    @JvmName("ukkhirqyxqdcdiro")
    public suspend fun destinationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationId = mapped
    }

    /**
     * @param value The parameter to enable or disable the timestamp.
     */
    @JvmName("bgmygqmskcijshxd")
    public suspend fun isTimestampEnabled(`value`: Either<String, BooleanEnumProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTimestampEnabled = mapped
    }

    /**
     * @param value The parameter to enable or disable the timestamp.
     */
    @JvmName("kxqmuppcwsvdnrry")
    public fun isTimestampEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isTimestampEnabled = mapped
    }

    /**
     * @param value The parameter to enable or disable the timestamp.
     */
    @JvmName("dhblnatfyxvdvqaf")
    public fun isTimestampEnabled(`value`: BooleanEnumProperty) {
        val toBeMapped = Either.ofRight<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isTimestampEnabled = mapped
    }

    /**
     * @param value The name of the match configuration. This is used when Goto type is provided. If Goto type is selected and no match configuration name is provided. It goes to next configuration.
     */
    @JvmName("cxcoyxmumnveatcv")
    public suspend fun matchConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchConfigurationName = mapped
    }

    /**
     * @param value Truncate. 0 indicates do not truncate.
     */
    @JvmName("hqekhijrduwfxtov")
    public suspend fun truncate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.truncate = mapped
    }

    /**
     * @param value Type of actions that can be performed.
     */
    @JvmName("dvjaqjrqeqhugvyj")
    public suspend fun type(`value`: Either<String, TapRuleActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of actions that can be performed.
     */
    @JvmName("wfjcbxofemajtaqj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TapRuleActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of actions that can be performed.
     */
    @JvmName("sshuivkqtlmdphxo")
    public fun type(`value`: TapRuleActionType) {
        val toBeMapped = Either.ofRight<String, TapRuleActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NetworkTapRuleActionArgs = NetworkTapRuleActionArgs(
        destinationId = destinationId,
        isTimestampEnabled = isTimestampEnabled,
        matchConfigurationName = matchConfigurationName,
        truncate = truncate,
        type = type,
    )
}
