@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConditionArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.EncapsulationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the match condition that is supported to filter the traffic.
 * @property encapsulationType Encapsulation Type that needs to be matched.
 * @property ipCondition IP condition that needs to be matched.
 * @property portCondition Defines the port condition that needs to be matched.
 * @property protocolTypes List of the protocols that need to be matched.
 * @property vlanMatchCondition Vlan match condition that needs to be matched.
 */
public data class NetworkTapRuleMatchConditionArgs(
    public val encapsulationType: Output<Either<String, EncapsulationType>>? = null,
    public val ipCondition: Output<IpMatchConditionArgs>? = null,
    public val portCondition: Output<PortConditionArgs>? = null,
    public val protocolTypes: Output<List<String>>? = null,
    public val vlanMatchCondition: Output<VlanMatchConditionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConditionArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConditionArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConditionArgs.builder()
            .encapsulationType(
                encapsulationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipCondition(ipCondition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portCondition(portCondition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocolTypes(protocolTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vlanMatchCondition(
                vlanMatchCondition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkTapRuleMatchConditionArgs].
 */
@PulumiTagMarker
public class NetworkTapRuleMatchConditionArgsBuilder internal constructor() {
    private var encapsulationType: Output<Either<String, EncapsulationType>>? = null

    private var ipCondition: Output<IpMatchConditionArgs>? = null

    private var portCondition: Output<PortConditionArgs>? = null

    private var protocolTypes: Output<List<String>>? = null

    private var vlanMatchCondition: Output<VlanMatchConditionArgs>? = null

    /**
     * @param value Encapsulation Type that needs to be matched.
     */
    @JvmName("qaiugnbkmadtjatf")
    public suspend fun encapsulationType(`value`: Output<Either<String, EncapsulationType>>) {
        this.encapsulationType = value
    }

    /**
     * @param value IP condition that needs to be matched.
     */
    @JvmName("dhpshjekomahkwnc")
    public suspend fun ipCondition(`value`: Output<IpMatchConditionArgs>) {
        this.ipCondition = value
    }

    /**
     * @param value Defines the port condition that needs to be matched.
     */
    @JvmName("fdxnblrfnclyfhnf")
    public suspend fun portCondition(`value`: Output<PortConditionArgs>) {
        this.portCondition = value
    }

    /**
     * @param value List of the protocols that need to be matched.
     */
    @JvmName("pdbpwbpirjtqbywc")
    public suspend fun protocolTypes(`value`: Output<List<String>>) {
        this.protocolTypes = value
    }

    @JvmName("aemhqdchsjupogeo")
    public suspend fun protocolTypes(vararg values: Output<String>) {
        this.protocolTypes = Output.all(values.asList())
    }

    /**
     * @param values List of the protocols that need to be matched.
     */
    @JvmName("vkvgdcdriavbtkxu")
    public suspend fun protocolTypes(values: List<Output<String>>) {
        this.protocolTypes = Output.all(values)
    }

    /**
     * @param value Vlan match condition that needs to be matched.
     */
    @JvmName("qttjekwktadxatnn")
    public suspend fun vlanMatchCondition(`value`: Output<VlanMatchConditionArgs>) {
        this.vlanMatchCondition = value
    }

    /**
     * @param value Encapsulation Type that needs to be matched.
     */
    @JvmName("ccxicrqqujgbeokj")
    public suspend fun encapsulationType(`value`: Either<String, EncapsulationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encapsulationType = mapped
    }

    /**
     * @param value Encapsulation Type that needs to be matched.
     */
    @JvmName("oixkndgptvwahitg")
    public fun encapsulationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncapsulationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encapsulationType = mapped
    }

    /**
     * @param value Encapsulation Type that needs to be matched.
     */
    @JvmName("qjniccjrrisqpdlp")
    public fun encapsulationType(`value`: EncapsulationType) {
        val toBeMapped = Either.ofRight<String, EncapsulationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encapsulationType = mapped
    }

    /**
     * @param value IP condition that needs to be matched.
     */
    @JvmName("ocxnqwgxhpgjteus")
    public suspend fun ipCondition(`value`: IpMatchConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipCondition = mapped
    }

    /**
     * @param argument IP condition that needs to be matched.
     */
    @JvmName("tsvggvnjxusflvnf")
    public suspend fun ipCondition(argument: suspend IpMatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = IpMatchConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipCondition = mapped
    }

    /**
     * @param value Defines the port condition that needs to be matched.
     */
    @JvmName("gaufeqcxodfynaef")
    public suspend fun portCondition(`value`: PortConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portCondition = mapped
    }

    /**
     * @param argument Defines the port condition that needs to be matched.
     */
    @JvmName("shhjwaxbymjxoxna")
    public suspend fun portCondition(argument: suspend PortConditionArgsBuilder.() -> Unit) {
        val toBeMapped = PortConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.portCondition = mapped
    }

    /**
     * @param value List of the protocols that need to be matched.
     */
    @JvmName("ttavbyjcrmsiufdq")
    public suspend fun protocolTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolTypes = mapped
    }

    /**
     * @param values List of the protocols that need to be matched.
     */
    @JvmName("qcolbwdvnwpbmgsn")
    public suspend fun protocolTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolTypes = mapped
    }

    /**
     * @param value Vlan match condition that needs to be matched.
     */
    @JvmName("hdximoxbeqdgmwsq")
    public suspend fun vlanMatchCondition(`value`: VlanMatchConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanMatchCondition = mapped
    }

    /**
     * @param argument Vlan match condition that needs to be matched.
     */
    @JvmName("bqpfepgxwtrmrixs")
    public suspend
    fun vlanMatchCondition(argument: suspend VlanMatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = VlanMatchConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vlanMatchCondition = mapped
    }

    internal fun build(): NetworkTapRuleMatchConditionArgs = NetworkTapRuleMatchConditionArgs(
        encapsulationType = encapsulationType,
        ipCondition = ipCondition,
        portCondition = portCondition,
        protocolTypes = protocolTypes,
        vlanMatchCondition = vlanMatchCondition,
    )
}
