@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.RoutePolicyStatementPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Route Policy Statement properties..
 * @property action Route policy action properties.
 * @property annotation Switch configuration description.
 * @property condition Route policy condition properties.
 * @property sequenceNumber Sequence to insert to/delete from existing route.
 */
public data class RoutePolicyStatementPropertiesArgs(
    public val action: Output<StatementActionPropertiesArgs>,
    public val `annotation`: Output<String>? = null,
    public val condition: Output<StatementConditionPropertiesArgs>,
    public val sequenceNumber: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.RoutePolicyStatementPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.RoutePolicyStatementPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.RoutePolicyStatementPropertiesArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .condition(condition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sequenceNumber(sequenceNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutePolicyStatementPropertiesArgs].
 */
@PulumiTagMarker
public class RoutePolicyStatementPropertiesArgsBuilder internal constructor() {
    private var action: Output<StatementActionPropertiesArgs>? = null

    private var `annotation`: Output<String>? = null

    private var condition: Output<StatementConditionPropertiesArgs>? = null

    private var sequenceNumber: Output<Double>? = null

    /**
     * @param value Route policy action properties.
     */
    @JvmName("redebeqddhybjjjr")
    public suspend fun action(`value`: Output<StatementActionPropertiesArgs>) {
        this.action = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("uiqlnhmqeamrgcsl")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Route policy condition properties.
     */
    @JvmName("npdhohfnaamausgo")
    public suspend fun condition(`value`: Output<StatementConditionPropertiesArgs>) {
        this.condition = value
    }

    /**
     * @param value Sequence to insert to/delete from existing route.
     */
    @JvmName("qpywakrfuhgecjbd")
    public suspend fun sequenceNumber(`value`: Output<Double>) {
        this.sequenceNumber = value
    }

    /**
     * @param value Route policy action properties.
     */
    @JvmName("ktfsvjywiytjcqso")
    public suspend fun action(`value`: StatementActionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Route policy action properties.
     */
    @JvmName("khweihhrbsrvldww")
    public suspend fun action(argument: suspend StatementActionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StatementActionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("qrkmwoglbqshnkwe")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Route policy condition properties.
     */
    @JvmName("avhnrjcmvnxidljf")
    public suspend fun condition(`value`: StatementConditionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Route policy condition properties.
     */
    @JvmName("ymukjjwnwsuggdqv")
    public suspend
    fun condition(argument: suspend StatementConditionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StatementConditionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value Sequence to insert to/delete from existing route.
     */
    @JvmName("uivegfaovcsapvgy")
    public suspend fun sequenceNumber(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sequenceNumber = mapped
    }

    internal fun build(): RoutePolicyStatementPropertiesArgs = RoutePolicyStatementPropertiesArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        `annotation` = `annotation`,
        condition = condition ?: throw PulumiNullFieldException("condition"),
        sequenceNumber = sequenceNumber ?: throw PulumiNullFieldException("sequenceNumber"),
    )
}
