@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Internet Gateway Rule resource definition.
 * @property annotation Switch configuration description.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property internetGatewayIds List of Internet Gateway resource Id.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource.
 * @property ruleProperties Rules for the InternetGateways
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetInternetGatewayRuleResult(
    public val `annotation`: String? = null,
    public val id: String,
    public val internetGatewayIds: List<String>,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val ruleProperties: RulePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetInternetGatewayRuleResult):
            GetInternetGatewayRuleResult = GetInternetGatewayRuleResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            internetGatewayIds = javaType.internetGatewayIds().map({ args0 -> args0 }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            ruleProperties = javaType.ruleProperties().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.RulePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
