@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The NetworkTapRule resource definition.
 * @property administrativeState Administrative state of the resource.
 * @property annotation Switch configuration description.
 * @property configurationState Configuration state of the resource.
 * @property configurationType Input method to configure Network Tap Rule.
 * @property dynamicMatchConfigurations List of dynamic match configurations.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lastSyncedTime The last sync timestamp.
 * @property location The geo-location where the resource lives
 * @property matchConfigurations List of match configurations.
 * @property name The name of the resource
 * @property networkTapId The ARM resource Id of the NetworkTap.
 * @property pollingIntervalInSeconds Polling interval in seconds.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property tapRulesUrl Network Tap Rules file URL.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkTapRuleResult(
    public val administrativeState: String,
    public val `annotation`: String? = null,
    public val configurationState: String,
    public val configurationType: String,
    public val dynamicMatchConfigurations: List<CommonDynamicMatchConfigurationResponse>? = null,
    public val id: String,
    public val lastSyncedTime: String,
    public val location: String,
    public val matchConfigurations: List<NetworkTapRuleMatchConfigurationResponse>? = null,
    public val name: String,
    public val networkTapId: String,
    public val pollingIntervalInSeconds: Int? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tapRulesUrl: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkTapRuleResult):
            GetNetworkTapRuleResult = GetNetworkTapRuleResult(
            administrativeState = javaType.administrativeState(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            configurationState = javaType.configurationState(),
            configurationType = javaType.configurationType(),
            dynamicMatchConfigurations = javaType.dynamicMatchConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.CommonDynamicMatchConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastSyncedTime = javaType.lastSyncedTime(),
            location = javaType.location(),
            matchConfigurations = javaType.matchConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapRuleMatchConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            networkTapId = javaType.networkTapId(),
            pollingIntervalInSeconds = javaType.pollingIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tapRulesUrl = javaType.tapRulesUrl().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
