@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InfrastructureServices IP ranges.
 * @property ipv4AddressSpaces The IPv4 Address space is optional, if the value is not defined at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet is an optional attribute.
 * @property ipv6AddressSpaces The IPv6 is not supported right now.
 */
public data class InfrastructureServicesResponse(
    public val ipv4AddressSpaces: List<String>? = null,
    public val ipv6AddressSpaces: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.InfrastructureServicesResponse):
            InfrastructureServicesResponse = InfrastructureServicesResponse(
            ipv4AddressSpaces = javaType.ipv4AddressSpaces().map({ args0 -> args0 }),
            ipv6AddressSpaces = javaType.ipv6AddressSpaces().map({ args0 -> args0 }),
        )
    }
}
