@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Isolation Domain Properties.
 * @property encapsulation Type of encapsulation.
 * @property neighborGroupIds List of Neighbor Group IDs.
 */
public data class IsolationDomainPropertiesResponse(
    public val encapsulation: String? = null,
    public val neighborGroupIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.IsolationDomainPropertiesResponse):
            IsolationDomainPropertiesResponse = IsolationDomainPropertiesResponse(
            encapsulation = javaType.encapsulation().map({ args0 -> args0 }).orElse(null),
            neighborGroupIds = javaType.neighborGroupIds().map({ args0 -> args0 }),
        )
    }
}
