@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Suppress

/**
 * Configuration to be used to setup the management network.
 * @property infrastructureVpnConfiguration Configuration for infrastructure vpn.
 * @property workloadVpnConfiguration Configuration for workload vpn.
 */
public data class ManagementNetworkConfigurationResponse(
    public val infrastructureVpnConfiguration: VpnConfigurationPropertiesResponse,
    public val workloadVpnConfiguration: VpnConfigurationPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.ManagementNetworkConfigurationResponse):
            ManagementNetworkConfigurationResponse = ManagementNetworkConfigurationResponse(
            infrastructureVpnConfiguration = javaType.infrastructureVpnConfiguration().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.VpnConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
            workloadVpnConfiguration = javaType.workloadVpnConfiguration().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.VpnConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
