@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The vlan match conditions that need to be matched.
 * @property innerVlans List of inner vlans that need to be matched.
 * @property vlanGroupNames List of vlan group names that need to be matched.
 * @property vlans List of vlans that need to be matched.
 */
public data class VlanMatchConditionResponse(
    public val innerVlans: List<String>? = null,
    public val vlanGroupNames: List<String>? = null,
    public val vlans: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.VlanMatchConditionResponse):
            VlanMatchConditionResponse = VlanMatchConditionResponse(
            innerVlans = javaType.innerVlans().map({ args0 -> args0 }),
            vlanGroupNames = javaType.vlanGroupNames().map({ args0 -> args0 }),
            vlans = javaType.vlans().map({ args0 -> args0 }),
        )
    }
}
