@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin

import com.pulumi.azurenative.managedservices.RegistrationDefinitionArgs.builder
import com.pulumi.azurenative.managedservices.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.managedservices.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.managedservices.kotlin.inputs.RegistrationDefinitionPropertiesArgs
import com.pulumi.azurenative.managedservices.kotlin.inputs.RegistrationDefinitionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The registration definition.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * ## Example Usage
 * ### Put Registration Definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registrationDefinition = new AzureNative.ManagedServices.RegistrationDefinition("registrationDefinition", new()
 *     {
 *         Plan = new AzureNative.ManagedServices.Inputs.PlanArgs
 *         {
 *             Name = "addesai-plan",
 *             Product = "test",
 *             Publisher = "marketplace-test",
 *             Version = "1.0.0",
 *         },
 *         Properties = new AzureNative.ManagedServices.Inputs.RegistrationDefinitionPropertiesArgs
 *         {
 *             Authorizations = new[]
 *             {
 *                 new AzureNative.ManagedServices.Inputs.AuthorizationArgs
 *                 {
 *                     PrincipalId = "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc",
 *                     PrincipalIdDisplayName = "Support User",
 *                     RoleDefinitionId = "acdd72a7-3385-48ef-bd42-f606fba81ae7",
 *                 },
 *                 new AzureNative.ManagedServices.Inputs.AuthorizationArgs
 *                 {
 *                     DelegatedRoleDefinitionIds = new[]
 *                     {
 *                         "b24988ac-6180-42a0-ab88-20f7382dd24c",
 *                     },
 *                     PrincipalId = "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc",
 *                     PrincipalIdDisplayName = "User Access Administrator",
 *                     RoleDefinitionId = "18d7d88d-d35e-4fb5-a5c3-7773c20a72d9",
 *                 },
 *             },
 *             Description = "Tes1t",
 *             EligibleAuthorizations = new[]
 *             {
 *                 new AzureNative.ManagedServices.Inputs.EligibleAuthorizationArgs
 *                 {
 *                     JustInTimeAccessPolicy = new AzureNative.ManagedServices.Inputs.JustInTimeAccessPolicyArgs
 *                     {
 *                         ManagedByTenantApprovers = new[]
 *                         {
 *                             new AzureNative.ManagedServices.Inputs.EligibleApproverArgs
 *                             {
 *                                 PrincipalId = "d9b22cd6-6407-43cc-8c60-07c56df0b51a",
 *                                 PrincipalIdDisplayName = "Approver Group",
 *                             },
 *                         },
 *                         MaximumActivationDuration = "PT8H",
 *                         MultiFactorAuthProvider = "Azure",
 *                     },
 *                     PrincipalId = "3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2",
 *                     PrincipalIdDisplayName = "Support User",
 *                     RoleDefinitionId = "ae349356-3a1b-4a5e-921d-050484c6347e",
 *                 },
 *             },
 *             ManagedByTenantId = "83abe5cd-bcc3-441a-bd86-e6a75360cecc",
 *             RegistrationDefinitionName = "DefinitionName",
 *         },
 *         RegistrationDefinitionId = "26c128c2-fefa-4340-9bb1-6e081c90ada2",
 *         Scope = "subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := managedservices.NewRegistrationDefinition(ctx, "registrationDefinition", &managedservices.RegistrationDefinitionArgs{
 * Plan: &managedservices.PlanArgs{
 * Name: pulumi.String("addesai-plan"),
 * Product: pulumi.String("test"),
 * Publisher: pulumi.String("marketplace-test"),
 * Version: pulumi.String("1.0.0"),
 * },
 * Properties: managedservices.RegistrationDefinitionPropertiesResponse{
 * Authorizations: managedservices.AuthorizationArray{
 * &managedservices.AuthorizationArgs{
 * PrincipalId: pulumi.String("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
 * PrincipalIdDisplayName: pulumi.String("Support User"),
 * RoleDefinitionId: pulumi.String("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
 * },
 * &managedservices.AuthorizationArgs{
 * DelegatedRoleDefinitionIds: pulumi.StringArray{
 * pulumi.String("b24988ac-6180-42a0-ab88-20f7382dd24c"),
 * },
 * PrincipalId: pulumi.String("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
 * PrincipalIdDisplayName: pulumi.String("User Access Administrator"),
 * RoleDefinitionId: pulumi.String("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
 * },
 * },
 * Description: pulumi.String("Tes1t"),
 * EligibleAuthorizations: managedservices.EligibleAuthorizationArray{
 * interface{}{
 * JustInTimeAccessPolicy: interface{}{
 * ManagedByTenantApprovers: managedservices.EligibleApproverArray{
 * &managedservices.EligibleApproverArgs{
 * PrincipalId: pulumi.String("d9b22cd6-6407-43cc-8c60-07c56df0b51a"),
 * PrincipalIdDisplayName: pulumi.String("Approver Group"),
 * },
 * },
 * MaximumActivationDuration: pulumi.String("PT8H"),
 * MultiFactorAuthProvider: pulumi.String("Azure"),
 * },
 * PrincipalId: pulumi.String("3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2"),
 * PrincipalIdDisplayName: pulumi.String("Support User"),
 * RoleDefinitionId: pulumi.String("ae349356-3a1b-4a5e-921d-050484c6347e"),
 * },
 * },
 * ManagedByTenantId: pulumi.String("83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
 * RegistrationDefinitionName: pulumi.String("DefinitionName"),
 * },
 * RegistrationDefinitionId: pulumi.String("26c128c2-fefa-4340-9bb1-6e081c90ada2"),
 * Scope: pulumi.String("subscription/0afefe50-734e-4610-8a82-a144ahf49dea"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedservices.RegistrationDefinition;
 * import com.pulumi.azurenative.managedservices.RegistrationDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registrationDefinition = new RegistrationDefinition("registrationDefinition", RegistrationDefinitionArgs.builder()
 *             .plan(Map.ofEntries(
 *                 Map.entry("name", "addesai-plan"),
 *                 Map.entry("product", "test"),
 *                 Map.entry("publisher", "marketplace-test"),
 *                 Map.entry("version", "1.0.0")
 *             ))
 *             .properties(Map.ofEntries(
 *                 Map.entry("authorizations",
 *                     Map.ofEntries(
 *                         Map.entry("principalId", "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
 *                         Map.entry("principalIdDisplayName", "Support User"),
 *                         Map.entry("roleDefinitionId", "acdd72a7-3385-48ef-bd42-f606fba81ae7")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("delegatedRoleDefinitionIds", "b24988ac-6180-42a0-ab88-20f7382dd24c"),
 *                         Map.entry("principalId", "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
 *                         Map.entry("principalIdDisplayName", "User Access Administrator"),
 *                         Map.entry("roleDefinitionId", "18d7d88d-d35e-4fb5-a5c3-7773c20a72d9")
 *                     )),
 *                 Map.entry("description", "Tes1t"),
 *                 Map.entry("eligibleAuthorizations", Map.ofEntries(
 *                     Map.entry("justInTimeAccessPolicy", Map.ofEntries(
 *                         Map.entry("managedByTenantApprovers", Map.ofEntries(
 *                             Map.entry("principalId", "d9b22cd6-6407-43cc-8c60-07c56df0b51a"),
 *                             Map.entry("principalIdDisplayName", "Approver Group")
 *                         )),
 *                         Map.entry("maximumActivationDuration", "PT8H"),
 *                         Map.entry("multiFactorAuthProvider", "Azure")
 *                     )),
 *                     Map.entry("principalId", "3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2"),
 *                     Map.entry("principalIdDisplayName", "Support User"),
 *                     Map.entry("roleDefinitionId", "ae349356-3a1b-4a5e-921d-050484c6347e")
 *                 )),
 *                 Map.entry("managedByTenantId", "83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
 *                 Map.entry("registrationDefinitionName", "DefinitionName")
 *             ))
 *             .registrationDefinitionId("26c128c2-fefa-4340-9bb1-6e081c90ada2")
 *             .scope("subscription/0afefe50-734e-4610-8a82-a144ahf49dea")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedservices:RegistrationDefinition 26c128c2-fefa-4340-9bb1-6e081c90ada2 /{scope}/providers/Microsoft.ManagedServices/registrationDefinitions/{registrationDefinitionId}
 * ```
 * @property plan The details for the Managed Services offer’s plan in Azure Marketplace.
 * @property properties The properties of a registration definition.
 * @property registrationDefinitionId The GUID of the registration definition.
 * @property scope The scope of the resource.
 */
public data class RegistrationDefinitionArgs(
    public val plan: Output<PlanArgs>? = null,
    public val properties: Output<RegistrationDefinitionPropertiesArgs>? = null,
    public val registrationDefinitionId: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.RegistrationDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.RegistrationDefinitionArgs =
        com.pulumi.azurenative.managedservices.RegistrationDefinitionArgs.builder()
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registrationDefinitionId(registrationDefinitionId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistrationDefinitionArgs].
 */
@PulumiTagMarker
public class RegistrationDefinitionArgsBuilder internal constructor() {
    private var plan: Output<PlanArgs>? = null

    private var properties: Output<RegistrationDefinitionPropertiesArgs>? = null

    private var registrationDefinitionId: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The details for the Managed Services offer’s plan in Azure Marketplace.
     */
    @JvmName("ngunotjctmptdvmk")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The properties of a registration definition.
     */
    @JvmName("rmlnlwxyuhjkqkoc")
    public suspend fun properties(`value`: Output<RegistrationDefinitionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The GUID of the registration definition.
     */
    @JvmName("yqfmuntxgiqmjqlf")
    public suspend fun registrationDefinitionId(`value`: Output<String>) {
        this.registrationDefinitionId = value
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("vkbghhqpswacqucf")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The details for the Managed Services offer’s plan in Azure Marketplace.
     */
    @JvmName("efifoxtsmlcldccy")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument The details for the Managed Services offer’s plan in Azure Marketplace.
     */
    @JvmName("raajscqxytkidiei")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The properties of a registration definition.
     */
    @JvmName("fskfccghorkmokkn")
    public suspend fun properties(`value`: RegistrationDefinitionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of a registration definition.
     */
    @JvmName("hwrrremqunwwthah")
    public suspend
    fun properties(argument: suspend RegistrationDefinitionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RegistrationDefinitionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The GUID of the registration definition.
     */
    @JvmName("sbglxhgrnpdwcwpb")
    public suspend fun registrationDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationDefinitionId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("vkhkilvwxswnupbk")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): RegistrationDefinitionArgs = RegistrationDefinitionArgs(
        plan = plan,
        properties = properties,
        registrationDefinitionId = registrationDefinitionId,
        scope = scope,
    )
}
