@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.EligibleAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Azure Active Directory principal identifier, Azure built-in role, and just-in-time access policy that describes the just-in-time access the principal will receive on the delegated resource in the managed tenant.
 * @property justInTimeAccessPolicy The just-in-time access policy setting.
 * @property principalId The identifier of the Azure Active Directory principal.
 * @property principalIdDisplayName The display name of the Azure Active Directory principal.
 * @property roleDefinitionId The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
 */
public data class EligibleAuthorizationArgs(
    public val justInTimeAccessPolicy: Output<JustInTimeAccessPolicyArgs>? = null,
    public val principalId: Output<String>,
    public val principalIdDisplayName: Output<String>? = null,
    public val roleDefinitionId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.EligibleAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.inputs.EligibleAuthorizationArgs =
        com.pulumi.azurenative.managedservices.inputs.EligibleAuthorizationArgs.builder()
            .justInTimeAccessPolicy(
                justInTimeAccessPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .principalIdDisplayName(principalIdDisplayName?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EligibleAuthorizationArgs].
 */
@PulumiTagMarker
public class EligibleAuthorizationArgsBuilder internal constructor() {
    private var justInTimeAccessPolicy: Output<JustInTimeAccessPolicyArgs>? = null

    private var principalId: Output<String>? = null

    private var principalIdDisplayName: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value The just-in-time access policy setting.
     */
    @JvmName("qtpjbpsdqewlckjk")
    public suspend fun justInTimeAccessPolicy(`value`: Output<JustInTimeAccessPolicyArgs>) {
        this.justInTimeAccessPolicy = value
    }

    /**
     * @param value The identifier of the Azure Active Directory principal.
     */
    @JvmName("jdmglhlabposiofy")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The display name of the Azure Active Directory principal.
     */
    @JvmName("pslkjvgwvraorlev")
    public suspend fun principalIdDisplayName(`value`: Output<String>) {
        this.principalIdDisplayName = value
    }

    /**
     * @param value The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
     */
    @JvmName("qsoloovjglgxfwpy")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The just-in-time access policy setting.
     */
    @JvmName("jkwhavgsbccgjbxp")
    public suspend fun justInTimeAccessPolicy(`value`: JustInTimeAccessPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.justInTimeAccessPolicy = mapped
    }

    /**
     * @param argument The just-in-time access policy setting.
     */
    @JvmName("yciqxvpbadvncssb")
    public suspend
    fun justInTimeAccessPolicy(argument: suspend JustInTimeAccessPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = JustInTimeAccessPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.justInTimeAccessPolicy = mapped
    }

    /**
     * @param value The identifier of the Azure Active Directory principal.
     */
    @JvmName("pkyimliavnbuxeyt")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The display name of the Azure Active Directory principal.
     */
    @JvmName("bfnbyrkoigumxoju")
    public suspend fun principalIdDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalIdDisplayName = mapped
    }

    /**
     * @param value The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
     */
    @JvmName("drwfalthggrvvseg")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): EligibleAuthorizationArgs = EligibleAuthorizationArgs(
        justInTimeAccessPolicy = justInTimeAccessPolicy,
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        principalIdDisplayName = principalIdDisplayName,
        roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
    )
}
