@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.PlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The details for the Managed Services offer’s plan in Azure Marketplace.
 * @property name Azure Marketplace plan name.
 * @property product Azure Marketplace product code.
 * @property publisher Azure Marketplace publisher ID.
 * @property version Azure Marketplace plan's version.
 */
public data class PlanArgs(
    public val name: Output<String>,
    public val product: Output<String>,
    public val publisher: Output<String>,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.PlanArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.inputs.PlanArgs =
        com.pulumi.azurenative.managedservices.inputs.PlanArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .product(product.applyValue({ args0 -> args0 }))
            .publisher(publisher.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var publisher: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Azure Marketplace plan name.
     */
    @JvmName("xlcmivggymsdpfku")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Marketplace product code.
     */
    @JvmName("uqpyxiygmsjytrti")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value Azure Marketplace publisher ID.
     */
    @JvmName("jwrcbcnrudvonkhy")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Azure Marketplace plan's version.
     */
    @JvmName("eikuhtxaaeaqqadr")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Azure Marketplace plan name.
     */
    @JvmName("exroqjgkaqebslex")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Azure Marketplace product code.
     */
    @JvmName("yejfumcdlsjcpkyd")
    public suspend fun product(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value Azure Marketplace publisher ID.
     */
    @JvmName("cjfoolfogjunshhw")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Azure Marketplace plan's version.
     */
    @JvmName("lfwibhipjvajjpmu")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        product = product ?: throw PulumiNullFieldException("product"),
        publisher = publisher ?: throw PulumiNullFieldException("publisher"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
