@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.azurenative.management.HierarchySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings defined at the Management Group scope.
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2023-04-01.
 * ## Example Usage
 * ### GetGroupSettings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hierarchySetting = new AzureNative.Management.HierarchySetting("hierarchySetting", new()
 *     {
 *         DefaultManagementGroup = "/providers/Microsoft.Management/managementGroups/DefaultGroup",
 *         GroupId = "root",
 *         RequireAuthorizationForGroupCreation = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/management/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := management.NewHierarchySetting(ctx, "hierarchySetting", &management.HierarchySettingArgs{
 * 			DefaultManagementGroup:               pulumi.String("/providers/Microsoft.Management/managementGroups/DefaultGroup"),
 * 			GroupId:                              pulumi.String("root"),
 * 			RequireAuthorizationForGroupCreation: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.management.HierarchySetting;
 * import com.pulumi.azurenative.management.HierarchySettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hierarchySetting = new HierarchySetting("hierarchySetting", HierarchySettingArgs.builder()
 *             .defaultManagementGroup("/providers/Microsoft.Management/managementGroups/DefaultGroup")
 *             .groupId("root")
 *             .requireAuthorizationForGroupCreation(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:management:HierarchySetting root /providers/Microsoft.Management/managementGroups/{groupId}/settings/default
 * ```
 * @property defaultManagementGroup Settings that sets the default Management Group under which new subscriptions get added in this tenant. For example, /providers/Microsoft.Management/managementGroups/defaultGroup
 * @property groupId Management Group ID.
 * @property requireAuthorizationForGroupCreation Indicates whether RBAC access is required upon group creation under the root Management Group. If set to true, user will require Microsoft.Management/managementGroups/write action on the root Management Group scope in order to create new Groups directly under the root. This will prevent new users from creating new Management Groups, unless they are given access.
 */
public data class HierarchySettingArgs(
    public val defaultManagementGroup: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val requireAuthorizationForGroupCreation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.HierarchySettingArgs> {
    override fun toJava(): com.pulumi.azurenative.management.HierarchySettingArgs =
        com.pulumi.azurenative.management.HierarchySettingArgs.builder()
            .defaultManagementGroup(defaultManagementGroup?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .requireAuthorizationForGroupCreation(
                requireAuthorizationForGroupCreation?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [HierarchySettingArgs].
 */
@PulumiTagMarker
public class HierarchySettingArgsBuilder internal constructor() {
    private var defaultManagementGroup: Output<String>? = null

    private var groupId: Output<String>? = null

    private var requireAuthorizationForGroupCreation: Output<Boolean>? = null

    /**
     * @param value Settings that sets the default Management Group under which new subscriptions get added in this tenant. For example, /providers/Microsoft.Management/managementGroups/defaultGroup
     */
    @JvmName("mfdoolntapcsrjfh")
    public suspend fun defaultManagementGroup(`value`: Output<String>) {
        this.defaultManagementGroup = value
    }

    /**
     * @param value Management Group ID.
     */
    @JvmName("emcmkfffcptgvxni")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Indicates whether RBAC access is required upon group creation under the root Management Group. If set to true, user will require Microsoft.Management/managementGroups/write action on the root Management Group scope in order to create new Groups directly under the root. This will prevent new users from creating new Management Groups, unless they are given access.
     */
    @JvmName("mdggrdplonkhweyj")
    public suspend fun requireAuthorizationForGroupCreation(`value`: Output<Boolean>) {
        this.requireAuthorizationForGroupCreation = value
    }

    /**
     * @param value Settings that sets the default Management Group under which new subscriptions get added in this tenant. For example, /providers/Microsoft.Management/managementGroups/defaultGroup
     */
    @JvmName("psrtfwdplyxgeclm")
    public suspend fun defaultManagementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultManagementGroup = mapped
    }

    /**
     * @param value Management Group ID.
     */
    @JvmName("xmetesifkrdembxk")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Indicates whether RBAC access is required upon group creation under the root Management Group. If set to true, user will require Microsoft.Management/managementGroups/write action on the root Management Group scope in order to create new Groups directly under the root. This will prevent new users from creating new Management Groups, unless they are given access.
     */
    @JvmName("rynffcqhehsxhgad")
    public suspend fun requireAuthorizationForGroupCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireAuthorizationForGroupCreation = mapped
    }

    internal fun build(): HierarchySettingArgs = HierarchySettingArgs(
        defaultManagementGroup = defaultManagementGroup,
        groupId = groupId,
        requireAuthorizationForGroupCreation = requireAuthorizationForGroupCreation,
    )
}
