@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.azurenative.management.ManagementGroupArgs.builder
import com.pulumi.azurenative.management.kotlin.inputs.CreateManagementGroupDetailsArgs
import com.pulumi.azurenative.management.kotlin.inputs.CreateManagementGroupDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The management group details.
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2017-11-01-preview, 2020-02-01, 2023-04-01.
 * ## Example Usage
 * ### PutManagementGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroup = new AzureNative.Management.ManagementGroup("managementGroup", new()
 *     {
 *         Details = new AzureNative.Management.Inputs.CreateManagementGroupDetailsArgs
 *         {
 *             Parent = new AzureNative.Management.Inputs.CreateParentGroupInfoArgs
 *             {
 *                 Id = "/providers/Microsoft.Management/managementGroups/RootGroup",
 *             },
 *         },
 *         DisplayName = "ChildGroup",
 *         GroupId = "ChildGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/management/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := management.NewManagementGroup(ctx, "managementGroup", &management.ManagementGroupArgs{
 * 			Details: management.ManagementGroupDetailsResponse{
 * 				Parent: &management.CreateParentGroupInfoArgs{
 * 					Id: pulumi.String("/providers/Microsoft.Management/managementGroups/RootGroup"),
 * 				},
 * 			},
 * 			DisplayName: pulumi.String("ChildGroup"),
 * 			GroupId:     pulumi.String("ChildGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.management.ManagementGroup;
 * import com.pulumi.azurenative.management.ManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroup = new ManagementGroup("managementGroup", ManagementGroupArgs.builder()
 *             .details(Map.of("parent", Map.of("id", "/providers/Microsoft.Management/managementGroups/RootGroup")))
 *             .displayName("ChildGroup")
 *             .groupId("ChildGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:management:ManagementGroup ChildGroup /providers/Microsoft.Management/managementGroups/{groupId}
 * ```
 * @property details The details of a management group used during creation.
 * @property displayName The friendly name of the management group. If no value is passed then this  field will be set to the groupId.
 * @property groupId Management Group ID.
 * @property name The name of the management group. For example, 00000000-0000-0000-0000-000000000000
 */
public data class ManagementGroupArgs(
    public val details: Output<CreateManagementGroupDetailsArgs>? = null,
    public val displayName: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.ManagementGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.management.ManagementGroupArgs =
        com.pulumi.azurenative.management.ManagementGroupArgs.builder()
            .details(details?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementGroupArgs].
 */
@PulumiTagMarker
public class ManagementGroupArgsBuilder internal constructor() {
    private var details: Output<CreateManagementGroupDetailsArgs>? = null

    private var displayName: Output<String>? = null

    private var groupId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The details of a management group used during creation.
     */
    @JvmName("cbybpghyakejtxxq")
    public suspend fun details(`value`: Output<CreateManagementGroupDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value The friendly name of the management group. If no value is passed then this  field will be set to the groupId.
     */
    @JvmName("lqdsecoegmjiovxo")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Management Group ID.
     */
    @JvmName("ndttfmavcpphdgqb")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the management group. For example, 00000000-0000-0000-0000-000000000000
     */
    @JvmName("qgnilbcjdxouphyv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The details of a management group used during creation.
     */
    @JvmName("ytvwxijleqtmrkgg")
    public suspend fun details(`value`: CreateManagementGroupDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument The details of a management group used during creation.
     */
    @JvmName("umqqvafparyypebe")
    public suspend fun details(argument: suspend CreateManagementGroupDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateManagementGroupDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    /**
     * @param value The friendly name of the management group. If no value is passed then this  field will be set to the groupId.
     */
    @JvmName("ukagjjorugbesinn")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Management Group ID.
     */
    @JvmName("yemqmovcqjybmyqs")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the management group. For example, 00000000-0000-0000-0000-000000000000
     */
    @JvmName("kjajranrtncnekxf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagementGroupArgs = ManagementGroupArgs(
        details = details,
        displayName = displayName,
        groupId = groupId,
        name = name,
    )
}
