@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.inputs

import com.pulumi.azurenative.management.inputs.CreateParentGroupInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * (Optional) The ID of the parent management group used during creation.
 * @property id The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
 */
public data class CreateParentGroupInfoArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.inputs.CreateParentGroupInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.management.inputs.CreateParentGroupInfoArgs =
        com.pulumi.azurenative.management.inputs.CreateParentGroupInfoArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateParentGroupInfoArgs].
 */
@PulumiTagMarker
public class CreateParentGroupInfoArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
     */
    @JvmName("nkvawismphaxahof")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
     */
    @JvmName("wnwngddedlplgqjh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): CreateParentGroupInfoArgs = CreateParentGroupInfoArgs(
        id = id,
    )
}
