@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.inputs

import com.pulumi.azurenative.management.inputs.GetEntityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter The filter parameter allows you to filter on the the name or display name fields. You can check for equality on the name field (e.g. name eq '{entityName}')  and you can check for substrings on either the name or display name fields(e.g. contains(name, '{substringToSearch}'), contains(displayName, '{substringToSearch')). Note that the '{entityName}' and '{substringToSearch}' fields are checked case insensitively.
 * @property groupName A filter which allows the get entities call to focus on a particular group (i.e. "$filter=name eq 'groupName'")
 * @property search The $search parameter is used in conjunction with the $filter parameter to return three different outputs depending on the parameter passed in.
 * With $search=AllowedParents the API will return the entity info of all groups that the requested entity will be able to reparent to as determined by the user's permissions.
 * With $search=AllowedChildren the API will return the entity info of all entities that can be added as children of the requested entity.
 * With $search=ParentAndFirstLevelChildren the API will return the parent and  first level of children that the user has either direct access to or indirect access via one of their descendants.
 * With $search=ParentOnly the API will return only the group if the user has access to at least one of the descendants of the group.
 * With $search=ChildrenOnly the API will return only the first level of children of the group entity info specified in $filter.  The user must have direct access to the children entities or one of it's descendants for it to show up in the results.
 * @property select This parameter specifies the fields to include in the response. Can include any combination of Name,DisplayName,Type,ParentDisplayNameChain,ParentChain, e.g. '$select=Name,DisplayName,Type,ParentDisplayNameChain,ParentNameChain'. When specified the $select parameter can override select in $skipToken.
 * @property skip Number of entities to skip over when retrieving results. Passing this in will override $skipToken.
 * @property skiptoken Page continuation token is only used if a previous operation returned a partial result.
 * If a previous response contains a nextLink element, the value of the nextLink element will include a token parameter that specifies a starting point to use for subsequent calls.
 * @property top Number of elements to return when retrieving results. Passing this in will override $skipToken.
 * @property view The view parameter allows clients to filter the type of data that is returned by the getEntities call.
 */
public data class GetEntityPlainArgs(
    public val filter: String? = null,
    public val groupName: String? = null,
    public val search: String? = null,
    public val select: String? = null,
    public val skip: Int? = null,
    public val skiptoken: String? = null,
    public val top: Int? = null,
    public val view: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.inputs.GetEntityPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.management.inputs.GetEntityPlainArgs =
        com.pulumi.azurenative.management.inputs.GetEntityPlainArgs.builder()
            .filter(filter?.let({ args0 -> args0 }))
            .groupName(groupName?.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .select(select?.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .skiptoken(skiptoken?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .view(view?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEntityPlainArgs].
 */
@PulumiTagMarker
public class GetEntityPlainArgsBuilder internal constructor() {
    private var filter: String? = null

    private var groupName: String? = null

    private var search: String? = null

    private var select: String? = null

    private var skip: Int? = null

    private var skiptoken: String? = null

    private var top: Int? = null

    private var view: String? = null

    /**
     * @param value The filter parameter allows you to filter on the the name or display name fields. You can check for equality on the name field (e.g. name eq '{entityName}')  and you can check for substrings on either the name or display name fields(e.g. contains(name, '{substringToSearch}'), contains(displayName, '{substringToSearch')). Note that the '{entityName}' and '{substringToSearch}' fields are checked case insensitively.
     */
    @JvmName("mpljjybrdsgugvjl")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value A filter which allows the get entities call to focus on a particular group (i.e. "$filter=name eq 'groupName'")
     */
    @JvmName("yydtdaabvxiokuhw")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value The $search parameter is used in conjunction with the $filter parameter to return three different outputs depending on the parameter passed in.
     * With $search=AllowedParents the API will return the entity info of all groups that the requested entity will be able to reparent to as determined by the user's permissions.
     * With $search=AllowedChildren the API will return the entity info of all entities that can be added as children of the requested entity.
     * With $search=ParentAndFirstLevelChildren the API will return the parent and  first level of children that the user has either direct access to or indirect access via one of their descendants.
     * With $search=ParentOnly the API will return only the group if the user has access to at least one of the descendants of the group.
     * With $search=ChildrenOnly the API will return only the first level of children of the group entity info specified in $filter.  The user must have direct access to the children entities or one of it's descendants for it to show up in the results.
     */
    @JvmName("pbrlgimcchqcyirb")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value This parameter specifies the fields to include in the response. Can include any combination of Name,DisplayName,Type,ParentDisplayNameChain,ParentChain, e.g. '$select=Name,DisplayName,Type,ParentDisplayNameChain,ParentNameChain'. When specified the $select parameter can override select in $skipToken.
     */
    @JvmName("ucvecikabcvqtgxo")
    public suspend fun select(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.select = mapped
    }

    /**
     * @param value Number of entities to skip over when retrieving results. Passing this in will override $skipToken.
     */
    @JvmName("qbffblojxokjapts")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value Page continuation token is only used if a previous operation returned a partial result.
     * If a previous response contains a nextLink element, the value of the nextLink element will include a token parameter that specifies a starting point to use for subsequent calls.
     */
    @JvmName("qspomyisqjrqsfwq")
    public suspend fun skiptoken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skiptoken = mapped
    }

    /**
     * @param value Number of elements to return when retrieving results. Passing this in will override $skipToken.
     */
    @JvmName("gqvysaybhrifemyr")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value The view parameter allows clients to filter the type of data that is returned by the getEntities call.
     */
    @JvmName("ppqqclnmqkimjqyt")
    public suspend fun view(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.view = mapped
    }

    internal fun build(): GetEntityPlainArgs = GetEntityPlainArgs(
        filter = filter,
        groupName = groupName,
        search = search,
        select = select,
        skip = skip,
        skiptoken = skiptoken,
        top = top,
        view = view,
    )
}
