@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managementpartner.kotlin

import com.pulumi.azurenative.managementpartner.ManagementpartnerFunctions.getPartnerPlain
import com.pulumi.azurenative.managementpartner.kotlin.inputs.GetPartnerPlainArgs
import com.pulumi.azurenative.managementpartner.kotlin.inputs.GetPartnerPlainArgsBuilder
import com.pulumi.azurenative.managementpartner.kotlin.outputs.GetPartnerResult
import com.pulumi.azurenative.managementpartner.kotlin.outputs.GetPartnerResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ManagementpartnerFunctions {
    /**
     * Get the management partner using the partnerId, objectId and tenantId.
     * Azure REST API version: 2018-02-01.
     * @param argument null
     * @return this is the management partner operations response
     */
    public suspend fun getPartner(argument: GetPartnerPlainArgs): GetPartnerResult =
        toKotlin(getPartnerPlain(argument.toJava()).await())

    /**
     * @see [getPartner].
     * @param partnerId Id of the Partner
     * @return this is the management partner operations response
     */
    public suspend fun getPartner(partnerId: String): GetPartnerResult {
        val argument = GetPartnerPlainArgs(
            partnerId = partnerId,
        )
        return toKotlin(getPartnerPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartner].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managementpartner&#46;kotlin&#46;inputs&#46;GetPartnerPlainArgs].
     * @return this is the management partner operations response
     */
    public suspend fun getPartner(argument: suspend GetPartnerPlainArgsBuilder.() -> Unit):
        GetPartnerResult {
        val builder = GetPartnerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getPartnerPlain(builtArgument.toJava()).await())
    }
}
