@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin

import com.pulumi.azurenative.marketplace.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.marketplace.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.marketplace.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.marketplace.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateStoreCollectionOffer].
 */
@PulumiTagMarker
public class PrivateStoreCollectionOfferResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateStoreCollectionOfferArgs = PrivateStoreCollectionOfferArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateStoreCollectionOfferArgsBuilder.() -> Unit) {
        val builder = PrivateStoreCollectionOfferArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateStoreCollectionOffer {
        val builtJavaResource =
            com.pulumi.azurenative.marketplace.PrivateStoreCollectionOffer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateStoreCollectionOffer(builtJavaResource)
    }
}

/**
 * The privateStore offer data structure.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### PrivateStoreOffer_update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateStoreCollectionOffer = new AzureNative.Marketplace.PrivateStoreCollectionOffer("privateStoreCollectionOffer", new()
 *     {
 *         CollectionId = "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d",
 *         ETag = "\"9301f4fd-0000-0100-0000-5e248b350666\"",
 *         OfferId = "marketplacetestthirdparty.md-test-third-party-2",
 *         PrivateStoreId = "a0e28e55-90c4-41d8-8e34-bb7ef7775406",
 *         SpecificPlanIdsLimitation = new[]
 *         {
 *             "0001",
 *             "0002",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/marketplace/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := marketplace.NewPrivateStoreCollectionOffer(ctx, "privateStoreCollectionOffer", &marketplace.PrivateStoreCollectionOfferArgs{
 * 			CollectionId:   pulumi.String("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
 * 			ETag:           pulumi.String("\"9301f4fd-0000-0100-0000-5e248b350666\""),
 * 			OfferId:        pulumi.String("marketplacetestthirdparty.md-test-third-party-2"),
 * 			PrivateStoreId: pulumi.String("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
 * 			SpecificPlanIdsLimitation: pulumi.StringArray{
 * 				pulumi.String("0001"),
 * 				pulumi.String("0002"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollectionOffer;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollectionOfferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateStoreCollectionOffer = new PrivateStoreCollectionOffer("privateStoreCollectionOffer", PrivateStoreCollectionOfferArgs.builder()
 *             .collectionId("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d")
 *             .eTag("\"9301f4fd-0000-0100-0000-5e248b350666\"")
 *             .offerId("marketplacetestthirdparty.md-test-third-party-2")
 *             .privateStoreId("a0e28e55-90c4-41d8-8e34-bb7ef7775406")
 *             .specificPlanIdsLimitation(
 *                 "0001",
 *                 "0002")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:marketplace:PrivateStoreCollectionOffer marketplacetestthirdparty.md-test-third-party-2 /providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers/{offerId}
 * ```
 */
public class PrivateStoreCollectionOffer internal constructor(
    override val javaResource: com.pulumi.azurenative.marketplace.PrivateStoreCollectionOffer,
) : KotlinCustomResource(javaResource, PrivateStoreCollectionOfferMapper) {
    /**
     * Private store offer creation date
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Identifier for purposes of race condition
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Icon File Uris
     */
    public val iconFileUris: Output<Map<String, String>>?
        get() = javaResource.iconFileUris().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Private store offer modification date
     */
    public val modifiedAt: Output<String>
        get() = javaResource.modifiedAt().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * It will be displayed prominently in the marketplace
     */
    public val offerDisplayName: Output<String>
        get() = javaResource.offerDisplayName().applyValue({ args0 -> args0 })

    /**
     * Offer plans
     */
    public val plans: Output<List<PlanResponse>>?
        get() = javaResource.plans().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> planResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Private store unique id
     */
    public val privateStoreId: Output<String>
        get() = javaResource.privateStoreId().applyValue({ args0 -> args0 })

    /**
     * Publisher name that will be displayed prominently in the marketplace
     */
    public val publisherDisplayName: Output<String>
        get() = javaResource.publisherDisplayName().applyValue({ args0 -> args0 })

    /**
     * Plan ids limitation for this offer
     */
    public val specificPlanIdsLimitation: Output<List<String>>?
        get() = javaResource.specificPlanIdsLimitation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Offers unique id
     */
    public val uniqueOfferId: Output<String>
        get() = javaResource.uniqueOfferId().applyValue({ args0 -> args0 })

    /**
     * Indicating whether the offer was not updated to db (true = not updated). If the allow list is identical to the existed one in db, the offer would not be updated.
     */
    public val updateSuppressedDueIdempotence: Output<Boolean>?
        get() = javaResource.updateSuppressedDueIdempotence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PrivateStoreCollectionOfferMapper : ResourceMapper<PrivateStoreCollectionOffer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.marketplace.PrivateStoreCollectionOffer::class == javaResource::class

    override fun map(javaResource: Resource): PrivateStoreCollectionOffer =
        PrivateStoreCollectionOffer(
            javaResource as
                com.pulumi.azurenative.marketplace.PrivateStoreCollectionOffer,
        )
}

/**
 * @see [PrivateStoreCollectionOffer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateStoreCollectionOffer].
 */
public suspend fun privateStoreCollectionOffer(
    name: String,
    block: suspend PrivateStoreCollectionOfferResourceBuilder.() -> Unit,
):
    PrivateStoreCollectionOffer {
    val builder = PrivateStoreCollectionOfferResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateStoreCollectionOffer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateStoreCollectionOffer(name: String): PrivateStoreCollectionOffer {
    val builder = PrivateStoreCollectionOfferResourceBuilder()
    builder.name(name)
    return builder.build()
}
