@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin

import com.pulumi.azurenative.marketplace.PrivateStoreCollectionOfferArgs.builder
import com.pulumi.azurenative.marketplace.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.marketplace.kotlin.inputs.PlanArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The privateStore offer data structure.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### PrivateStoreOffer_update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateStoreCollectionOffer = new AzureNative.Marketplace.PrivateStoreCollectionOffer("privateStoreCollectionOffer", new()
 *     {
 *         CollectionId = "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d",
 *         ETag = "\"9301f4fd-0000-0100-0000-5e248b350666\"",
 *         OfferId = "marketplacetestthirdparty.md-test-third-party-2",
 *         PrivateStoreId = "a0e28e55-90c4-41d8-8e34-bb7ef7775406",
 *         SpecificPlanIdsLimitation = new[]
 *         {
 *             "0001",
 *             "0002",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/marketplace/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := marketplace.NewPrivateStoreCollectionOffer(ctx, "privateStoreCollectionOffer", &marketplace.PrivateStoreCollectionOfferArgs{
 * 			CollectionId:   pulumi.String("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
 * 			ETag:           pulumi.String("\"9301f4fd-0000-0100-0000-5e248b350666\""),
 * 			OfferId:        pulumi.String("marketplacetestthirdparty.md-test-third-party-2"),
 * 			PrivateStoreId: pulumi.String("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
 * 			SpecificPlanIdsLimitation: pulumi.StringArray{
 * 				pulumi.String("0001"),
 * 				pulumi.String("0002"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollectionOffer;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollectionOfferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateStoreCollectionOffer = new PrivateStoreCollectionOffer("privateStoreCollectionOffer", PrivateStoreCollectionOfferArgs.builder()
 *             .collectionId("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d")
 *             .eTag("\"9301f4fd-0000-0100-0000-5e248b350666\"")
 *             .offerId("marketplacetestthirdparty.md-test-third-party-2")
 *             .privateStoreId("a0e28e55-90c4-41d8-8e34-bb7ef7775406")
 *             .specificPlanIdsLimitation(
 *                 "0001",
 *                 "0002")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:marketplace:PrivateStoreCollectionOffer marketplacetestthirdparty.md-test-third-party-2 /providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers/{offerId}
 * ```
 * @property collectionId The collection ID
 * @property eTag Identifier for purposes of race condition
 * @property iconFileUris Icon File Uris
 * @property offerId The offer ID to update or delete
 * @property plans Offer plans
 * @property privateStoreId The store ID - must use the tenant ID
 * @property specificPlanIdsLimitation Plan ids limitation for this offer
 * @property updateSuppressedDueIdempotence Indicating whether the offer was not updated to db (true = not updated). If the allow list is identical to the existed one in db, the offer would not be updated.
 */
public data class PrivateStoreCollectionOfferArgs(
    public val collectionId: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val iconFileUris: Output<Map<String, String>>? = null,
    public val offerId: Output<String>? = null,
    public val plans: Output<List<PlanArgs>>? = null,
    public val privateStoreId: Output<String>? = null,
    public val specificPlanIdsLimitation: Output<List<String>>? = null,
    public val updateSuppressedDueIdempotence: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.marketplace.PrivateStoreCollectionOfferArgs> {
    override fun toJava(): com.pulumi.azurenative.marketplace.PrivateStoreCollectionOfferArgs =
        com.pulumi.azurenative.marketplace.PrivateStoreCollectionOfferArgs.builder()
            .collectionId(collectionId?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .iconFileUris(
                iconFileUris?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .offerId(offerId?.applyValue({ args0 -> args0 }))
            .plans(plans?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .privateStoreId(privateStoreId?.applyValue({ args0 -> args0 }))
            .specificPlanIdsLimitation(
                specificPlanIdsLimitation?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .updateSuppressedDueIdempotence(
                updateSuppressedDueIdempotence?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [PrivateStoreCollectionOfferArgs].
 */
@PulumiTagMarker
public class PrivateStoreCollectionOfferArgsBuilder internal constructor() {
    private var collectionId: Output<String>? = null

    private var eTag: Output<String>? = null

    private var iconFileUris: Output<Map<String, String>>? = null

    private var offerId: Output<String>? = null

    private var plans: Output<List<PlanArgs>>? = null

    private var privateStoreId: Output<String>? = null

    private var specificPlanIdsLimitation: Output<List<String>>? = null

    private var updateSuppressedDueIdempotence: Output<Boolean>? = null

    /**
     * @param value The collection ID
     */
    @JvmName("pthnrdewsufqnnew")
    public suspend fun collectionId(`value`: Output<String>) {
        this.collectionId = value
    }

    /**
     * @param value Identifier for purposes of race condition
     */
    @JvmName("vybibrepmqfpkwqi")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Icon File Uris
     */
    @JvmName("fcsltauxybxldjpd")
    public suspend fun iconFileUris(`value`: Output<Map<String, String>>) {
        this.iconFileUris = value
    }

    /**
     * @param value The offer ID to update or delete
     */
    @JvmName("utawmqbbrnaxhaga")
    public suspend fun offerId(`value`: Output<String>) {
        this.offerId = value
    }

    /**
     * @param value Offer plans
     */
    @JvmName("alujptiwxgngecma")
    public suspend fun plans(`value`: Output<List<PlanArgs>>) {
        this.plans = value
    }

    @JvmName("kdlxagaqinqlneab")
    public suspend fun plans(vararg values: Output<PlanArgs>) {
        this.plans = Output.all(values.asList())
    }

    /**
     * @param values Offer plans
     */
    @JvmName("wjjvjycjygvwleww")
    public suspend fun plans(values: List<Output<PlanArgs>>) {
        this.plans = Output.all(values)
    }

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("nygmfxoblkugkwpp")
    public suspend fun privateStoreId(`value`: Output<String>) {
        this.privateStoreId = value
    }

    /**
     * @param value Plan ids limitation for this offer
     */
    @JvmName("etolpjjpwuymxtmj")
    public suspend fun specificPlanIdsLimitation(`value`: Output<List<String>>) {
        this.specificPlanIdsLimitation = value
    }

    @JvmName("msiljfpmgxrsnnmj")
    public suspend fun specificPlanIdsLimitation(vararg values: Output<String>) {
        this.specificPlanIdsLimitation = Output.all(values.asList())
    }

    /**
     * @param values Plan ids limitation for this offer
     */
    @JvmName("nawogjnrorlmghoh")
    public suspend fun specificPlanIdsLimitation(values: List<Output<String>>) {
        this.specificPlanIdsLimitation = Output.all(values)
    }

    /**
     * @param value Indicating whether the offer was not updated to db (true = not updated). If the allow list is identical to the existed one in db, the offer would not be updated.
     */
    @JvmName("hdquieuhiblabnup")
    public suspend fun updateSuppressedDueIdempotence(`value`: Output<Boolean>) {
        this.updateSuppressedDueIdempotence = value
    }

    /**
     * @param value The collection ID
     */
    @JvmName("gbbnrdcpyvghsrhe")
    public suspend fun collectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionId = mapped
    }

    /**
     * @param value Identifier for purposes of race condition
     */
    @JvmName("ptffuahkhvmeroet")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Icon File Uris
     */
    @JvmName("kujlndwnmyiflbrt")
    public suspend fun iconFileUris(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconFileUris = mapped
    }

    /**
     * @param values Icon File Uris
     */
    @JvmName("qarowxcsiqhjsqaf")
    public fun iconFileUris(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iconFileUris = mapped
    }

    /**
     * @param value The offer ID to update or delete
     */
    @JvmName("lwlpbewgkwlblfhj")
    public suspend fun offerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerId = mapped
    }

    /**
     * @param value Offer plans
     */
    @JvmName("buyhgcuoobmyurqn")
    public suspend fun plans(`value`: List<PlanArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plans = mapped
    }

    /**
     * @param argument Offer plans
     */
    @JvmName("gbfojcrtnrfqdetx")
    public suspend fun plans(argument: List<suspend PlanArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PlanArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.plans = mapped
    }

    /**
     * @param argument Offer plans
     */
    @JvmName("xakeghpgqlcbubbr")
    public suspend fun plans(vararg argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PlanArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.plans = mapped
    }

    /**
     * @param argument Offer plans
     */
    @JvmName("pibuxujnvuqfykml")
    public suspend fun plans(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlanArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.plans = mapped
    }

    /**
     * @param values Offer plans
     */
    @JvmName("srihmvlxwlcxqdpk")
    public suspend fun plans(vararg values: PlanArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.plans = mapped
    }

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("bwcvwhwxkqnpuhyw")
    public suspend fun privateStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateStoreId = mapped
    }

    /**
     * @param value Plan ids limitation for this offer
     */
    @JvmName("chltlkcrmdpbflte")
    public suspend fun specificPlanIdsLimitation(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specificPlanIdsLimitation = mapped
    }

    /**
     * @param values Plan ids limitation for this offer
     */
    @JvmName("ejixkjxbbhwocsei")
    public suspend fun specificPlanIdsLimitation(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.specificPlanIdsLimitation = mapped
    }

    /**
     * @param value Indicating whether the offer was not updated to db (true = not updated). If the allow list is identical to the existed one in db, the offer would not be updated.
     */
    @JvmName("svulilsgffwqylxl")
    public suspend fun updateSuppressedDueIdempotence(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateSuppressedDueIdempotence = mapped
    }

    internal fun build(): PrivateStoreCollectionOfferArgs = PrivateStoreCollectionOfferArgs(
        collectionId = collectionId,
        eTag = eTag,
        iconFileUris = iconFileUris,
        offerId = offerId,
        plans = plans,
        privateStoreId = privateStoreId,
        specificPlanIdsLimitation = specificPlanIdsLimitation,
        updateSuppressedDueIdempotence = updateSuppressedDueIdempotence,
    )
}
