@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.inputs

import com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionOfferPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectionId The collection ID
 * @property offerId The offer ID to update or delete
 * @property privateStoreId The store ID - must use the tenant ID
 */
public data class GetPrivateStoreCollectionOfferPlainArgs(
    public val collectionId: String,
    public val offerId: String,
    public val privateStoreId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionOfferPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionOfferPlainArgs =
        com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionOfferPlainArgs.builder()
            .collectionId(collectionId.let({ args0 -> args0 }))
            .offerId(offerId.let({ args0 -> args0 }))
            .privateStoreId(privateStoreId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateStoreCollectionOfferPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateStoreCollectionOfferPlainArgsBuilder internal constructor() {
    private var collectionId: String? = null

    private var offerId: String? = null

    private var privateStoreId: String? = null

    /**
     * @param value The collection ID
     */
    @JvmName("evqjxikvhnvofbbk")
    public suspend fun collectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collectionId = mapped
    }

    /**
     * @param value The offer ID to update or delete
     */
    @JvmName("wiodbbkhtxcqwjdw")
    public suspend fun offerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.offerId = mapped
    }

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("unmhmhcchqtimxsh")
    public suspend fun privateStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateStoreId = mapped
    }

    internal fun build(): GetPrivateStoreCollectionOfferPlainArgs =
        GetPrivateStoreCollectionOfferPlainArgs(
            collectionId = collectionId ?: throw PulumiNullFieldException("collectionId"),
            offerId = offerId ?: throw PulumiNullFieldException("offerId"),
            privateStoreId = privateStoreId ?: throw PulumiNullFieldException("privateStoreId"),
        )
}
