@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Plan notification details
 * @property planDisplayName Gets or sets the plan display name
 * @property planId Gets or sets the plan id
 */
public data class PlanNotificationDetailsResponse(
    public val planDisplayName: String? = null,
    public val planId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.marketplace.outputs.PlanNotificationDetailsResponse):
            PlanNotificationDetailsResponse = PlanNotificationDetailsResponse(
            planDisplayName = javaType.planDisplayName().map({ args0 -> args0 }).orElse(null),
            planId = javaType.planId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
