@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessibility Plan accessibility
 * @property altStackReference Alternative stack type
 * @property planDisplayName Friendly name for the plan for display in the marketplace
 * @property planId Text identifier for this plan
 * @property skuId Identifier for this plan
 * @property stackType Stack type (classic or arm)
 */
public data class PlanResponse(
    public val accessibility: String? = null,
    public val altStackReference: String,
    public val planDisplayName: String,
    public val planId: String,
    public val skuId: String,
    public val stackType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.marketplace.outputs.PlanResponse):
            PlanResponse = PlanResponse(
            accessibility = javaType.accessibility().map({ args0 -> args0 }).orElse(null),
            altStackReference = javaType.altStackReference(),
            planDisplayName = javaType.planDisplayName(),
            planId = javaType.planId(),
            skuId = javaType.skuId(),
            stackType = javaType.stackType(),
        )
    }
}
