@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.FilterTrackSelectionResponse
import com.pulumi.azurenative.media.kotlin.outputs.FirstQualityResponse
import com.pulumi.azurenative.media.kotlin.outputs.PresentationTimeRangeResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.media.kotlin.outputs.FilterTrackSelectionResponse.Companion.toKotlin as filterTrackSelectionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.FirstQualityResponse.Companion.toKotlin as firstQualityResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.PresentationTimeRangeResponse.Companion.toKotlin as presentationTimeRangeResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AccountFilter].
 */
@PulumiTagMarker
public class AccountFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountFilterArgs = AccountFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountFilterArgsBuilder.() -> Unit) {
        val builder = AccountFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccountFilter {
        val builtJavaResource = com.pulumi.azurenative.media.AccountFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountFilter(builtJavaResource)
    }
}

/**
 * An Account Filter.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create an Account Filter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accountFilter = new AzureNative.Media.AccountFilter("accountFilter", new()
 *     {
 *         AccountName = "contosomedia",
 *         FilterName = "newAccountFilter",
 *         FirstQuality = new AzureNative.Media.Inputs.FirstQualityArgs
 *         {
 *             Bitrate = 128000,
 *         },
 *         PresentationTimeRange = new AzureNative.Media.Inputs.PresentationTimeRangeArgs
 *         {
 *             EndTimestamp = 170000000,
 *             ForceEndTimestamp = false,
 *             LiveBackoffDuration = 0,
 *             PresentationWindowDuration = 9223372036854774784,
 *             StartTimestamp = 0,
 *             Timescale = 10000000,
 *         },
 *         ResourceGroupName = "contosorg",
 *         Tracks = new[]
 *         {
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Type",
 *                         Value = "Audio",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "NotEqual",
 *                         Property = "Language",
 *                         Value = "en",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "NotEqual",
 *                         Property = "FourCC",
 *                         Value = "EC-3",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Type",
 *                         Value = "Video",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Bitrate",
 *                         Value = "3000000-5000000",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAccountFilter(ctx, "accountFilter", &media.AccountFilterArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			FilterName:  pulumi.String("newAccountFilter"),
 * 			FirstQuality: &media.FirstQualityArgs{
 * 				Bitrate: pulumi.Int(128000),
 * 			},
 * 			PresentationTimeRange: &media.PresentationTimeRangeArgs{
 * 				EndTimestamp:               pulumi.Float64(170000000),
 * 				ForceEndTimestamp:          pulumi.Bool(false),
 * 				LiveBackoffDuration:        pulumi.Float64(0),
 * 				PresentationWindowDuration: pulumi.Float64(9223372036854774784),
 * 				StartTimestamp:             pulumi.Float64(0),
 * 				Timescale:                  pulumi.Float64(10000000),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Tracks: []media.FilterTrackSelectionArgs{
 * 				{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Type"),
 * 							Value:     pulumi.String("Audio"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("NotEqual"),
 * 							Property:  pulumi.String("Language"),
 * 							Value:     pulumi.String("en"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("NotEqual"),
 * 							Property:  pulumi.String("FourCC"),
 * 							Value:     pulumi.String("EC-3"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Type"),
 * 							Value:     pulumi.String("Video"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Bitrate"),
 * 							Value:     pulumi.String("3000000-5000000"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.AccountFilter;
 * import com.pulumi.azurenative.media.AccountFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accountFilter = new AccountFilter("accountFilter", AccountFilterArgs.builder()
 *             .accountName("contosomedia")
 *             .filterName("newAccountFilter")
 *             .firstQuality(Map.of("bitrate", 128000))
 *             .presentationTimeRange(Map.ofEntries(
 *                 Map.entry("endTimestamp", 170000000),
 *                 Map.entry("forceEndTimestamp", false),
 *                 Map.entry("liveBackoffDuration", 0),
 *                 Map.entry("presentationWindowDuration", 9223372036854774784),
 *                 Map.entry("startTimestamp", 0),
 *                 Map.entry("timescale", 10000000)
 *             ))
 *             .resourceGroupName("contosorg")
 *             .tracks(
 *                 Map.of("trackSelections",
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Type"),
 *                         Map.entry("value", "Audio")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "NotEqual"),
 *                         Map.entry("property", "Language"),
 *                         Map.entry("value", "en")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "NotEqual"),
 *                         Map.entry("property", "FourCC"),
 *                         Map.entry("value", "EC-3")
 *                     )),
 *                 Map.of("trackSelections",
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Type"),
 *                         Map.entry("value", "Video")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Bitrate"),
 *                         Map.entry("value", "3000000-5000000")
 *                     )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:AccountFilter newAccountFilter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/accountFilters/{filterName}
 * ```
 */
public class AccountFilter internal constructor(
    override val javaResource: com.pulumi.azurenative.media.AccountFilter,
) : KotlinCustomResource(javaResource, AccountFilterMapper) {
    /**
     * The first quality.
     */
    public val firstQuality: Output<FirstQualityResponse>?
        get() = javaResource.firstQuality().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firstQualityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The presentation time range.
     */
    public val presentationTimeRange: Output<PresentationTimeRangeResponse>?
        get() = javaResource.presentationTimeRange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> presentationTimeRangeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tracks selection conditions.
     */
    public val tracks: Output<List<FilterTrackSelectionResponse>>?
        get() = javaResource.tracks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> filterTrackSelectionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountFilterMapper : ResourceMapper<AccountFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.AccountFilter::class == javaResource::class

    override fun map(javaResource: Resource): AccountFilter = AccountFilter(
        javaResource as
            com.pulumi.azurenative.media.AccountFilter,
    )
}

/**
 * @see [AccountFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountFilter].
 */
public suspend fun accountFilter(
    name: String,
    block: suspend AccountFilterResourceBuilder.() -> Unit,
): AccountFilter {
    val builder = AccountFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountFilter(name: String): AccountFilter {
    val builder = AccountFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
