@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Asset].
 */
@PulumiTagMarker
public class AssetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssetArgs = AssetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssetArgsBuilder.() -> Unit) {
        val builder = AssetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Asset {
        val builtJavaResource = com.pulumi.azurenative.media.Asset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Asset(builtJavaResource)
    }
}

/**
 * An Asset.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create an Asset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.Media.Asset("asset", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountLogan",
 *         Description = "A documentary showing the ascent of Mount Logan",
 *         ResourceGroupName = "contosorg",
 *         StorageAccountName = "storage0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAsset(ctx, "asset", &media.AssetArgs{
 * 			AccountName:        pulumi.String("contosomedia"),
 * 			AssetName:          pulumi.String("ClimbingMountLogan"),
 * 			Description:        pulumi.String("A documentary showing the ascent of Mount Logan"),
 * 			ResourceGroupName:  pulumi.String("contosorg"),
 * 			StorageAccountName: pulumi.String("storage0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Asset;
 * import com.pulumi.azurenative.media.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountLogan")
 *             .description("A documentary showing the ascent of Mount Logan")
 *             .resourceGroupName("contosorg")
 *             .storageAccountName("storage0")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset with encryption scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.Media.Asset("asset", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountLogan",
 *         Description = "A documentary showing the ascent of Mount Logan",
 *         EncryptionScope = "encryptionScope1",
 *         ResourceGroupName = "contosorg",
 *         StorageAccountName = "storage0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAsset(ctx, "asset", &media.AssetArgs{
 * 			AccountName:        pulumi.String("contosomedia"),
 * 			AssetName:          pulumi.String("ClimbingMountLogan"),
 * 			Description:        pulumi.String("A documentary showing the ascent of Mount Logan"),
 * 			EncryptionScope:    pulumi.String("encryptionScope1"),
 * 			ResourceGroupName:  pulumi.String("contosorg"),
 * 			StorageAccountName: pulumi.String("storage0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Asset;
 * import com.pulumi.azurenative.media.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountLogan")
 *             .description("A documentary showing the ascent of Mount Logan")
 *             .encryptionScope("encryptionScope1")
 *             .resourceGroupName("contosorg")
 *             .storageAccountName("storage0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Asset ClimbingMountLogan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}
 * ```
 */
public class Asset internal constructor(
    override val javaResource: com.pulumi.azurenative.media.Asset,
) : KotlinCustomResource(javaResource, AssetMapper) {
    /**
     * The alternate ID of the Asset.
     */
    public val alternateId: Output<String>?
        get() = javaResource.alternateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Asset ID.
     */
    public val assetId: Output<String>
        get() = javaResource.assetId().applyValue({ args0 -> args0 })

    /**
     * The name of the asset blob container.
     */
    public val container: Output<String>?
        get() = javaResource.container().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation date of the Asset.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * The Asset description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Asset container encryption scope in the storage account.
     */
    public val encryptionScope: Output<String>?
        get() = javaResource.encryptionScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last modified date of the Asset.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the storage account.
     */
    public val storageAccountName: Output<String>?
        get() = javaResource.storageAccountName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Asset encryption format. One of None or MediaStorageEncryption.
     */
    public val storageEncryptionFormat: Output<String>
        get() = javaResource.storageEncryptionFormat().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssetMapper : ResourceMapper<Asset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.Asset::class == javaResource::class

    override fun map(javaResource: Resource): Asset = Asset(
        javaResource as
            com.pulumi.azurenative.media.Asset,
    )
}

/**
 * @see [Asset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Asset].
 */
public suspend fun asset(name: String, block: suspend AssetResourceBuilder.() -> Unit): Asset {
    val builder = AssetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Asset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun asset(name: String): Asset {
    val builder = AssetResourceBuilder()
    builder.name(name)
    return builder.build()
}
