@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.ContentKeyPolicyArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.ContentKeyPolicyOptionArgs
import com.pulumi.azurenative.media.kotlin.inputs.ContentKeyPolicyOptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A Content Key Policy resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Creates a Content Key Policy with ClearKey option and Token Restriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyWithClearKeyOptionAndSwtTokenRestriction",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyClearKeyConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 *                 },
 *                 Name = "ClearKeyOption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyTokenRestrictionArgs
 *                 {
 *                     Audience = "urn:audience",
 *                     Issuer = "urn:issuer",
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 *                     PrimaryVerificationKey = new AzureNative.Media.Inputs.ContentKeyPolicySymmetricTokenKeyArgs
 *                     {
 *                         KeyValue = "AAAAAAAAAAAAAAAAAAAAAA==",
 *                         OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 *                     },
 *                     RestrictionTokenType = "Swt",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyWithClearKeyOptionAndSwtTokenRestriction"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: []media.ContentKeyPolicyOptionArgs{
 * 				{
 * 					Configuration: {
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 * 					},
 * 					Name: pulumi.String("ClearKeyOption"),
 * 					Restriction: {
 * 						Audience:  "urn:audience",
 * 						Issuer:    "urn:issuer",
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 * 						PrimaryVerificationKey: {
 * 							KeyValue:  "AAAAAAAAAAAAAAAAAAAAAA==",
 * 							OdataType: "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 * 						},
 * 						RestrictionTokenType: "Swt",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyWithClearKeyOptionAndSwtTokenRestriction")
 *             .description("ArmPolicyDescription")
 *             .options(Map.ofEntries(
 *                 Map.entry("configuration", Map.of("odataType", "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration")),
 *                 Map.entry("name", "ClearKeyOption"),
 *                 Map.entry("restriction", Map.ofEntries(
 *                     Map.entry("audience", "urn:audience"),
 *                     Map.entry("issuer", "urn:issuer"),
 *                     Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
 *                     Map.entry("primaryVerificationKey", Map.ofEntries(
 *                         Map.entry("keyValue", "AAAAAAAAAAAAAAAAAAAAAA=="),
 *                         Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey")
 *                     )),
 *                     Map.entry("restrictionTokenType", "Swt")
 *                 ))
 *             ))
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Content Key Policy with PlayReady option and Open Restriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyConfigurationArgs
 *                 {
 *                     Licenses = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyLicenseArgs
 *                         {
 *                             AllowTestDevices = true,
 *                             BeginDate = "2017-10-16T18:22:53.46Z",
 *                             ContentKeyLocation = new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs
 *                             {
 *                                 OdataType = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader",
 *                             },
 *                             ContentType = "UltraVioletDownload",
 *                             LicenseType = "Persistent",
 *                             PlayRight = new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyPlayRightArgs
 *                             {
 *                                 AllowPassingVideoContentToUnknownOutput = "NotAllowed",
 *                                 DigitalVideoOnlyContentRestriction = false,
 *                                 ImageConstraintForAnalogComponentVideoRestriction = true,
 *                                 ImageConstraintForAnalogComputerMonitorRestriction = false,
 *                                 ScmsRestriction = 2,
 *                             },
 *                             SecurityLevel = "SL150",
 *                         },
 *                     },
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration",
 *                 },
 *                 Name = "ArmPolicyOptionName",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyOpenRestrictionArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyWithPlayReadyOptionAndOpenRestriction"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: []media.ContentKeyPolicyOptionArgs{
 * 				{
 * 					Configuration: {
 * 						Licenses: []media.ContentKeyPolicyPlayReadyLicense{
 * 							{
 * 								AllowTestDevices: true,
 * 								BeginDate:        "2017-10-16T18:22:53.46Z",
 * 								ContentKeyLocation: {
 * 									OdataType: "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader",
 * 								},
 * 								ContentType: "UltraVioletDownload",
 * 								LicenseType: "Persistent",
 * 								PlayRight: {
 * 									AllowPassingVideoContentToUnknownOutput:            "NotAllowed",
 * 									DigitalVideoOnlyContentRestriction:                 false,
 * 									ImageConstraintForAnalogComponentVideoRestriction:  true,
 * 									ImageConstraintForAnalogComputerMonitorRestriction: false,
 * 									ScmsRestriction: 2,
 * 								},
 * 								SecurityLevel: "SL150",
 * 							},
 * 						},
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration",
 * 					},
 * 					Name: pulumi.String("ArmPolicyOptionName"),
 * 					Restriction: {
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyWithPlayReadyOptionAndOpenRestriction")
 *             .description("ArmPolicyDescription")
 *             .options(Map.ofEntries(
 *                 Map.entry("configuration", Map.ofEntries(
 *                     Map.entry("licenses", Map.ofEntries(
 *                         Map.entry("allowTestDevices", true),
 *                         Map.entry("beginDate", "2017-10-16T18:22:53.46Z"),
 *                         Map.entry("contentKeyLocation", Map.of("odataType", "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader")),
 *                         Map.entry("contentType", "UltraVioletDownload"),
 *                         Map.entry("licenseType", "Persistent"),
 *                         Map.entry("playRight", Map.ofEntries(
 *                             Map.entry("allowPassingVideoContentToUnknownOutput", "NotAllowed"),
 *                             Map.entry("digitalVideoOnlyContentRestriction", false),
 *                             Map.entry("imageConstraintForAnalogComponentVideoRestriction", true),
 *                             Map.entry("imageConstraintForAnalogComputerMonitorRestriction", false),
 *                             Map.entry("scmsRestriction", 2)
 *                         )),
 *                         Map.entry("securityLevel", "SL150")
 *                     )),
 *                     Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration")
 *                 )),
 *                 Map.entry("name", "ArmPolicyOptionName"),
 *                 Map.entry("restriction", Map.of("odataType", "#Microsoft.Media.ContentKeyPolicyOpenRestriction"))
 *             ))
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Content Key Policy with Widevine option and Token Restriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyWithWidevineOptionAndJwtTokenRestriction",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyWidevineConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 *                     WidevineTemplate = "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 *                 },
 *                 Name = "widevineoption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyTokenRestrictionArgs
 *                 {
 *                     AlternateVerificationKeys = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.ContentKeyPolicySymmetricTokenKeyArgs
 *                         {
 *                             KeyValue = "AAAAAAAAAAAAAAAAAAAAAA==",
 *                             OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 *                         },
 *                     },
 *                     Audience = "urn:audience",
 *                     Issuer = "urn:issuer",
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 *                     PrimaryVerificationKey = new AzureNative.Media.Inputs.ContentKeyPolicyRsaTokenKeyArgs
 *                     {
 *                         Exponent = "AQAB",
 *                         Modulus = "AQAD",
 *                         OdataType = "#Microsoft.Media.ContentKeyPolicyRsaTokenKey",
 *                     },
 *                     RestrictionTokenType = "Jwt",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyWithWidevineOptionAndJwtTokenRestriction"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: []media.ContentKeyPolicyOptionArgs{
 * 				{
 * 					Configuration: {
 * 						OdataType:        "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 * 						WidevineTemplate: "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 * 					},
 * 					Name: pulumi.String("widevineoption"),
 * 					Restriction: {
 * 						AlternateVerificationKeys: []interface{}{
 * 							{
 * 								KeyValue:  "AAAAAAAAAAAAAAAAAAAAAA==",
 * 								OdataType: "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 * 							},
 * 						},
 * 						Audience:  "urn:audience",
 * 						Issuer:    "urn:issuer",
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 * 						PrimaryVerificationKey: {
 * 							Exponent:  "AQAB",
 * 							Modulus:   "AQAD",
 * 							OdataType: "#Microsoft.Media.ContentKeyPolicyRsaTokenKey",
 * 						},
 * 						RestrictionTokenType: "Jwt",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyWithWidevineOptionAndJwtTokenRestriction")
 *             .description("ArmPolicyDescription")
 *             .options(Map.ofEntries(
 *                 Map.entry("configuration", Map.ofEntries(
 *                     Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
 *                     Map.entry("widevineTemplate", "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}")
 *                 )),
 *                 Map.entry("name", "widevineoption"),
 *                 Map.entry("restriction", Map.ofEntries(
 *                     Map.entry("alternateVerificationKeys", Map.ofEntries(
 *                         Map.entry("keyValue", "AAAAAAAAAAAAAAAAAAAAAA=="),
 *                         Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey")
 *                     )),
 *                     Map.entry("audience", "urn:audience"),
 *                     Map.entry("issuer", "urn:issuer"),
 *                     Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
 *                     Map.entry("primaryVerificationKey", Map.ofEntries(
 *                         Map.entry("exponent", "AQAB"),
 *                         Map.entry("modulus", "AQAD"),
 *                         Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyRsaTokenKey")
 *                     )),
 *                     Map.entry("restrictionTokenType", "Jwt")
 *                 ))
 *             ))
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Content Key Policy with multiple options
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyCreatedWithMultipleOptions",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyClearKeyConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 *                 },
 *                 Name = "ClearKeyOption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyTokenRestrictionArgs
 *                 {
 *                     Audience = "urn:audience",
 *                     Issuer = "urn:issuer",
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 *                     PrimaryVerificationKey = new AzureNative.Media.Inputs.ContentKeyPolicySymmetricTokenKeyArgs
 *                     {
 *                         KeyValue = "AAAAAAAAAAAAAAAAAAAAAA==",
 *                         OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 *                     },
 *                     RestrictionTokenType = "Swt",
 *                 },
 *             },
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyWidevineConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 *                     WidevineTemplate = "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 *                 },
 *                 Name = "widevineoption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyOpenRestrictionArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyCreatedWithMultipleOptions"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: []media.ContentKeyPolicyOptionArgs{
 * 				{
 * 					Configuration: {
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 * 					},
 * 					Name: pulumi.String("ClearKeyOption"),
 * 					Restriction: {
 * 						Audience:  "urn:audience",
 * 						Issuer:    "urn:issuer",
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 * 						PrimaryVerificationKey: {
 * 							KeyValue:  "AAAAAAAAAAAAAAAAAAAAAA==",
 * 							OdataType: "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 * 						},
 * 						RestrictionTokenType: "Swt",
 * 					},
 * 				},
 * 				{
 * 					Configuration: {
 * 						OdataType:        "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 * 						WidevineTemplate: "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 * 					},
 * 					Name: pulumi.String("widevineoption"),
 * 					Restriction: {
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyCreatedWithMultipleOptions")
 *             .description("ArmPolicyDescription")
 *             .options(
 *                 Map.ofEntries(
 *                     Map.entry("configuration", Map.of("odataType", "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration")),
 *                     Map.entry("name", "ClearKeyOption"),
 *                     Map.entry("restriction", Map.ofEntries(
 *                         Map.entry("audience", "urn:audience"),
 *                         Map.entry("issuer", "urn:issuer"),
 *                         Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
 *                         Map.entry("primaryVerificationKey", Map.ofEntries(
 *                             Map.entry("keyValue", "AAAAAAAAAAAAAAAAAAAAAA=="),
 *                             Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey")
 *                         )),
 *                         Map.entry("restrictionTokenType", "Swt")
 *                     ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("configuration", Map.ofEntries(
 *                         Map.entry("odataType", "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
 *                         Map.entry("widevineTemplate", "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}")
 *                     )),
 *                     Map.entry("name", "widevineoption"),
 *                     Map.entry("restriction", Map.of("odataType", "#Microsoft.Media.ContentKeyPolicyOpenRestriction"))
 *                 ))
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:ContentKeyPolicy PolicyCreatedWithMultipleOptions /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}
 * ```
 * @property accountName The Media Services account name.
 * @property contentKeyPolicyName The Content Key Policy name.
 * @property description A description for the Policy.
 * @property options The Key Policy options.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class ContentKeyPolicyArgs(
    public val accountName: Output<String>? = null,
    public val contentKeyPolicyName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val options: Output<List<ContentKeyPolicyOptionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.ContentKeyPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.ContentKeyPolicyArgs =
        com.pulumi.azurenative.media.ContentKeyPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .contentKeyPolicyName(contentKeyPolicyName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .options(
                options?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var contentKeyPolicyName: Output<String>? = null

    private var description: Output<String>? = null

    private var options: Output<List<ContentKeyPolicyOptionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("vshjctvughgyhmyb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Content Key Policy name.
     */
    @JvmName("pyrcfutvyagmrayo")
    public suspend fun contentKeyPolicyName(`value`: Output<String>) {
        this.contentKeyPolicyName = value
    }

    /**
     * @param value A description for the Policy.
     */
    @JvmName("nfpjgjdfcrvyeyld")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Key Policy options.
     */
    @JvmName("dyrkvhssinfvceyg")
    public suspend fun options(`value`: Output<List<ContentKeyPolicyOptionArgs>>) {
        this.options = value
    }

    @JvmName("pmfkyykmaaewvsgs")
    public suspend fun options(vararg values: Output<ContentKeyPolicyOptionArgs>) {
        this.options = Output.all(values.asList())
    }

    /**
     * @param values The Key Policy options.
     */
    @JvmName("yseupwxkxroxgivd")
    public suspend fun options(values: List<Output<ContentKeyPolicyOptionArgs>>) {
        this.options = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("rxgomxtnxawqvajh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("ndixjnbgnxqykvyh")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Content Key Policy name.
     */
    @JvmName("xoimksqhuqsfwice")
    public suspend fun contentKeyPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKeyPolicyName = mapped
    }

    /**
     * @param value A description for the Policy.
     */
    @JvmName("jargeyckivooaiou")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Key Policy options.
     */
    @JvmName("gflyhvojltrxsmvn")
    public suspend fun options(`value`: List<ContentKeyPolicyOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument The Key Policy options.
     */
    @JvmName("fuhmvdyvcafclykw")
    public suspend fun options(argument: List<suspend ContentKeyPolicyOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContentKeyPolicyOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument The Key Policy options.
     */
    @JvmName("ngefklivtilfnaxw")
    public suspend fun options(
        vararg
        argument: suspend ContentKeyPolicyOptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContentKeyPolicyOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument The Key Policy options.
     */
    @JvmName("pvwdbfjgsncdywjr")
    public suspend fun options(argument: suspend ContentKeyPolicyOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContentKeyPolicyOptionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param values The Key Policy options.
     */
    @JvmName("vymhtdclubvuwlmi")
    public suspend fun options(vararg values: ContentKeyPolicyOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("subynedritrhwvds")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ContentKeyPolicyArgs = ContentKeyPolicyArgs(
        accountName = accountName,
        contentKeyPolicyName = contentKeyPolicyName,
        description = description,
        options = options,
        resourceGroupName = resourceGroupName,
    )
}
