@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.media.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Update private endpoint connection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Media.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AccountName = "contososports",
 *         Name = "connectionName1",
 *         PrivateLinkServiceConnectionState = new AzureNative.Media.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Test description.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &media.PrivateEndpointConnectionArgs{
 * 			AccountName: pulumi.String("contososports"),
 * 			Name:        pulumi.String("connectionName1"),
 * 			PrivateLinkServiceConnectionState: &media.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Test description."),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.PrivateEndpointConnection;
 * import com.pulumi.azurenative.media.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .accountName("contososports")
 *             .name("connectionName1")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Test description."),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:PrivateEndpointConnection connectionName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/privateEndpointConnections/{name}
 * ```
 * @property accountName The Media Services account name.
 * @property name
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class PrivateEndpointConnectionArgs(
    public val accountName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.media.PrivateEndpointConnectionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var name: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("oibfcgcxkubjdjus")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value
     */
    @JvmName("oaadtsntgqouuuiv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("oydtlsonjbgmajsj")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("fnkkiqrlrjqnivsw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("mupmgglvxqcmnlvl")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ymjkpjvdyaacffmy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("oqawujqcgwdjvanh")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("ctkygkikuyhowfij")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("qiwgcqtvlgmeyerh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        accountName = accountName,
        name = name,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
