@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.TransformArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.TransformOutputArgs
import com.pulumi.azurenative.media.kotlin.inputs.TransformOutputArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as by transcoding or by extracting insights. After the Transform is created, it can be applied to input media by creating Jobs.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update a Transform
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var transform = new AzureNative.Media.Transform("transform", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "Example Transform to illustrate create and update.",
 *         Outputs = new[]
 *         {
 *             new AzureNative.Media.Inputs.TransformOutputArgs
 *             {
 *                 Preset = new AzureNative.Media.Inputs.BuiltInStandardEncoderPresetArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.BuiltInStandardEncoderPreset",
 *                     PresetName = "AdaptiveStreaming",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosoresources",
 *         TransformName = "createdTransform",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewTransform(ctx, "transform", &media.TransformArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			Description: pulumi.String("Example Transform to illustrate create and update."),
 * 			Outputs: []media.TransformOutputTypeArgs{
 * 				{
 * 					Preset: {
 * 						OdataType:  "#Microsoft.Media.BuiltInStandardEncoderPreset",
 * 						PresetName: "AdaptiveStreaming",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosoresources"),
 * 			TransformName:     pulumi.String("createdTransform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Transform;
 * import com.pulumi.azurenative.media.TransformArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transform = new Transform("transform", TransformArgs.builder()
 *             .accountName("contosomedia")
 *             .description("Example Transform to illustrate create and update.")
 *             .outputs(Map.of("preset", Map.ofEntries(
 *                 Map.entry("odataType", "#Microsoft.Media.BuiltInStandardEncoderPreset"),
 *                 Map.entry("presetName", "AdaptiveStreaming")
 *             )))
 *             .resourceGroupName("contosoresources")
 *             .transformName("createdTransform")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Transform createdTransform /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}
 * ```
 * @property accountName The Media Services account name.
 * @property description An optional verbose description of the Transform.
 * @property outputs An array of one or more TransformOutputs that the Transform should generate.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property transformName The Transform name.
 */
public data class TransformArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val outputs: Output<List<TransformOutputArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val transformName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.TransformArgs> {
    override fun toJava(): com.pulumi.azurenative.media.TransformArgs =
        com.pulumi.azurenative.media.TransformArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .transformName(transformName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransformArgs].
 */
@PulumiTagMarker
public class TransformArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var outputs: Output<List<TransformOutputArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var transformName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("rgjowmlmryafnpqw")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value An optional verbose description of the Transform.
     */
    @JvmName("hgdmdfyehgtnlwqv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("mmjnrwbttlqdisod")
    public suspend fun outputs(`value`: Output<List<TransformOutputArgs>>) {
        this.outputs = value
    }

    @JvmName("jbqkwglppkmsiqrh")
    public suspend fun outputs(vararg values: Output<TransformOutputArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("olwutkihuhujxlnr")
    public suspend fun outputs(values: List<Output<TransformOutputArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("artpcomkqlaqkxpg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Transform name.
     */
    @JvmName("tedyycflmayfjuhw")
    public suspend fun transformName(`value`: Output<String>) {
        this.transformName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("xgnaeprgkmwlyxnw")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value An optional verbose description of the Transform.
     */
    @JvmName("yaobvkrylwsqtrsw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("dpvwqvarseprsjqc")
    public suspend fun outputs(`value`: List<TransformOutputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("xaomdtgsugmvdgtu")
    public suspend fun outputs(argument: List<suspend TransformOutputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TransformOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("bqcjddnvuvttovof")
    public suspend fun outputs(vararg argument: suspend TransformOutputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TransformOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("hnbkupygdcxhjoha")
    public suspend fun outputs(argument: suspend TransformOutputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TransformOutputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values An array of one or more TransformOutputs that the Transform should generate.
     */
    @JvmName("ucdetygmxsvbjlsg")
    public suspend fun outputs(vararg values: TransformOutputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("kefsefhdarksmlpo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Transform name.
     */
    @JvmName("bcasjeldprhxwqnw")
    public suspend fun transformName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformName = mapped
    }

    internal fun build(): TransformArgs = TransformArgs(
        accountName = accountName,
        description = description,
        outputs = outputs,
        resourceGroupName = resourceGroupName,
        transformName = transformName,
    )
}
