@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The permissions to set on the SAS URL.
 */
public enum class AssetContainerPermission(
    public val javaValue: com.pulumi.azurenative.media.enums.AssetContainerPermission,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.AssetContainerPermission> {
    /**
     * The SAS URL will allow read access to the container.
     */
    Read(com.pulumi.azurenative.media.enums.AssetContainerPermission.Read),

    /**
     * The SAS URL will allow read and write access to the container.
     */
    ReadWrite(com.pulumi.azurenative.media.enums.AssetContainerPermission.ReadWrite),

    /**
     * The SAS URL will allow read, write and delete access to the container.
     */
    ReadWriteDelete(com.pulumi.azurenative.media.enums.AssetContainerPermission.ReadWriteDelete),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.AssetContainerPermission = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.AssetContainerPermission):
            AssetContainerPermission =
            AssetContainerPermission.values().first { it.javaValue == javaType }
    }
}
