@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
 */
public enum class AudioAnalysisMode(
    public val javaValue: com.pulumi.azurenative.media.enums.AudioAnalysisMode,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.AudioAnalysisMode> {
    /**
     * Performs all operations included in the Basic mode, additionally performing language detection and speaker diarization.
     */
    Standard(com.pulumi.azurenative.media.enums.AudioAnalysisMode.Standard),

    /**
     * This mode performs speech-to-text transcription and generation of a VTT subtitle/caption file. The output of this mode includes an Insights JSON file including only the keywords, transcription,and timing information. Automatic language detection and speaker diarization are not included in this mode.
     */
    Basic(com.pulumi.azurenative.media.enums.AudioAnalysisMode.Basic),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.AudioAnalysisMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.AudioAnalysisMode):
            AudioAnalysisMode = AudioAnalysisMode.values().first { it.javaValue == javaType }
    }
}
