@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The behavior for IP access control in Key Delivery.
 */
public enum class DefaultAction(
    public val javaValue: com.pulumi.azurenative.media.enums.DefaultAction,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.DefaultAction> {
    /**
     * All public IP addresses are allowed.
     */
    Allow(com.pulumi.azurenative.media.enums.DefaultAction.Allow),

    /**
     * Public IP addresses are blocked.
     */
    Deny(com.pulumi.azurenative.media.enums.DefaultAction.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.DefaultAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.DefaultAction): DefaultAction =
            DefaultAction.values().first { it.javaValue == javaType }
    }
}
