@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
 */
public enum class H265Complexity(
    public val javaValue: com.pulumi.azurenative.media.enums.H265Complexity,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.H265Complexity> {
    /**
     * Tells the encoder to use settings that are optimized for faster encoding. Quality is sacrificed to decrease encoding time.
     */
    Speed(com.pulumi.azurenative.media.enums.H265Complexity.Speed),

    /**
     * Tells the encoder to use settings that achieve a balance between speed and quality.
     */
    Balanced(com.pulumi.azurenative.media.enums.H265Complexity.Balanced),

    /**
     * Tells the encoder to use settings that are optimized to produce higher quality output at the expense of slower overall encode time.
     */
    Quality(com.pulumi.azurenative.media.enums.H265Complexity.Quality),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.H265Complexity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.H265Complexity): H265Complexity =
            H265Complexity.values().first { it.javaValue == javaType }
    }
}
