@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
 */
public enum class LiveEventEncodingType(
    public val javaValue: com.pulumi.azurenative.media.enums.LiveEventEncodingType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.LiveEventEncodingType> {
    /**
     * This is the same as PassthroughStandard, please see description below. This enumeration value is being deprecated.
     */
    None(com.pulumi.azurenative.media.enums.LiveEventEncodingType.None),

    /**
     * A contribution live encoder sends a single bitrate stream to the live event and Media Services creates multiple bitrate streams. The output cannot exceed 720p in resolution.
     */
    Standard(com.pulumi.azurenative.media.enums.LiveEventEncodingType.Standard),

    /**
     * A contribution live encoder sends a single bitrate stream to the live event and Media Services creates multiple bitrate streams. The output cannot exceed 1080p in resolution.
     */
    Premium1080p(com.pulumi.azurenative.media.enums.LiveEventEncodingType.Premium1080p),

    /**
     * The ingested stream passes through the live event from the contribution encoder without any further processing. In the PassthroughBasic mode, ingestion is limited to up to 5Mbps and only 1 concurrent live output is allowed. Live transcription is not available.
     */
    PassthroughBasic(com.pulumi.azurenative.media.enums.LiveEventEncodingType.PassthroughBasic),

    /**
     * The ingested stream passes through the live event from the contribution encoder without any further processing. Live transcription is available. Ingestion bitrate limits are much higher and up to 3 concurrent live outputs are allowed.
     */
    PassthroughStandard(com.pulumi.azurenative.media.enums.LiveEventEncodingType.PassthroughStandard),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.LiveEventEncodingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.LiveEventEncodingType):
            LiveEventEncodingType = LiveEventEncodingType.values().first { it.javaValue == javaType }
    }
}
