@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
 */
public enum class OnErrorType(
    public val javaValue: com.pulumi.azurenative.media.enums.OnErrorType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.OnErrorType> {
    /**
     * Tells the service that if this TransformOutput fails, then any other incomplete TransformOutputs can be stopped.
     */
    StopProcessingJob(com.pulumi.azurenative.media.enums.OnErrorType.StopProcessingJob),

    /**
     * Tells the service that if this TransformOutput fails, then allow any other TransformOutput to continue.
     */
    ContinueJob(com.pulumi.azurenative.media.enums.OnErrorType.ContinueJob),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.OnErrorType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.OnErrorType): OnErrorType =
            OnErrorType.values().first { it.javaValue == javaType }
    }
}
