@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Track property type
 */
public enum class TrackPropertyType(
    public val javaValue: com.pulumi.azurenative.media.enums.TrackPropertyType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.TrackPropertyType> {
    /**
     * Unknown track property
     */
    Unknown(com.pulumi.azurenative.media.enums.TrackPropertyType.Unknown),

    /**
     * Track FourCC
     */
    FourCC(com.pulumi.azurenative.media.enums.TrackPropertyType.FourCC),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.TrackPropertyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.TrackPropertyType):
            TrackPropertyType = TrackPropertyType.values().first { it.javaValue == javaType }
    }
}
