@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
 */
public enum class Visibility(
    public val javaValue: com.pulumi.azurenative.media.enums.Visibility,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.Visibility> {
    /**
     * The track is hidden to video player.
     */
    Hidden(com.pulumi.azurenative.media.enums.Visibility.Hidden),

    /**
     * The track is visible to video player.
     */
    Visible(com.pulumi.azurenative.media.enums.Visibility.Visible),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.Visibility = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.Visibility): Visibility =
            Visibility.values().first { it.javaValue == javaType }
    }
}
