@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AkamaiSignatureHeaderAuthenticationKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Akamai Signature Header authentication key.
 * @property base64Key authentication key
 * @property expiration The expiration time of the authentication key.
 * @property identifier identifier of the key
 */
public data class AkamaiSignatureHeaderAuthenticationKeyArgs(
    public val base64Key: Output<String>? = null,
    public val expiration: Output<String>? = null,
    public val identifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.AkamaiSignatureHeaderAuthenticationKeyArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.AkamaiSignatureHeaderAuthenticationKeyArgs =
        com.pulumi.azurenative.media.inputs.AkamaiSignatureHeaderAuthenticationKeyArgs.builder()
            .base64Key(base64Key?.applyValue({ args0 -> args0 }))
            .expiration(expiration?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AkamaiSignatureHeaderAuthenticationKeyArgs].
 */
@PulumiTagMarker
public class AkamaiSignatureHeaderAuthenticationKeyArgsBuilder internal constructor() {
    private var base64Key: Output<String>? = null

    private var expiration: Output<String>? = null

    private var identifier: Output<String>? = null

    /**
     * @param value authentication key
     */
    @JvmName("myidtysomcqmwhro")
    public suspend fun base64Key(`value`: Output<String>) {
        this.base64Key = value
    }

    /**
     * @param value The expiration time of the authentication key.
     */
    @JvmName("xrfopophhdulcdvl")
    public suspend fun expiration(`value`: Output<String>) {
        this.expiration = value
    }

    /**
     * @param value identifier of the key
     */
    @JvmName("ofqhmeirbugperef")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value authentication key
     */
    @JvmName("xldbmykvicxpwjpr")
    public suspend fun base64Key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base64Key = mapped
    }

    /**
     * @param value The expiration time of the authentication key.
     */
    @JvmName("rfwupcsmvvutfjlw")
    public suspend fun expiration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param value identifier of the key
     */
    @JvmName("mjwefwuwaijpkbur")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    internal fun build(): AkamaiSignatureHeaderAuthenticationKeyArgs =
        AkamaiSignatureHeaderAuthenticationKeyArgs(
            base64Key = base64Key,
            expiration = expiration,
            identifier = identifier,
        )
}
